﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using EffectCombiner.Primitives;

namespace EffectCombinerUnitTests
{
    [TestClass]
    public class MRUManagerTest
    {
        [TestMethod]
        public void MaxItemsTest()
        {
            var rand = new Random();
            var manager = new MRUManager<int>();
            var lastCount = 0;
            for (int i = 0; i < 1000; ++i)
            {
                var item = rand.Next();
                manager.IndicateAsUsed(item);

                if (manager.RecentlyUsed.First() != item)
                    throw new Exception(string.Format("MRUManager's first item is {0} while last used was {1}", manager.RecentlyUsed.First(), item));

                var count = manager.RecentlyUsed.Count();
                if (count > manager.MaxItems)
                    throw new Exception(string.Format("MRUManager has {0} items while max is {1}", count, manager.MaxItems));

                if (count < lastCount)
                    throw new Exception(string.Format("MRUManager has {0} items while it previously had {1}", count, lastCount));

                lastCount = count;
            }
        }
    }
}
