﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Blocks.Core;
using EffectCombiner.Primitives.Generation;

namespace EffectCombiner.Primitives.Operations
{
    public class ConstValueChangeOperation : OperationBase
    {
        private readonly uint instanceIdentifier;
        private readonly string[,] newValues;
        private readonly string[,] oldValues;

        public ConstValueChangeOperation(
            BlockManagerBase blockManager,
            BlockElementBase constantBlockElement,
            string[,] oldValues,
            string[,] newValues)
            : base(OperationType.ConstantValueChange, blockManager)
        {
            if (constantBlockElement == null)
                throw new ArgumentNullException("constantBlockElement");
            if (newValues == null)
                throw new ArgumentNullException("newValues");
            if (oldValues == null)
                throw new ArgumentNullException("oldValues");

            this.instanceIdentifier = constantBlockElement.InstanceIdentifier;
            this.newValues = Core.CoreUtility.DuplicateArray(newValues);
            this.oldValues = Core.CoreUtility.DuplicateArray(oldValues);
        }

        public override void Rollback()
        {
            var block = FindBlock<ConstantBlockElement>(instanceIdentifier);

            block.Values = oldValues;
            block.UpdateData();
        }

        public override void Execute()
        {
            var block = FindBlock<ConstantBlockElement>(instanceIdentifier);

            block.Values = newValues;
            block.UpdateData();
        }
    }
}
