﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Blocks.Core;

namespace EffectCombiner.Primitives.Blocks
{
    /// <summary>
    /// ブロックエレメントの編集パネルのインターフェースです。
    /// </summary>
    public interface IBlockElementEditPanel
    {
        /// <summary>
        /// 指定されたブロックエレメントがこのパネルで編集可能かどうか取得します。
        /// </summary>
        /// <param name="blockElement">ブロックエレメント</param>
        /// <returns>編集可能なときはtrue、それ以外はfalseを返します。</returns>
        bool CanEditBlockElement(BlockElementBase blockElement);

        /// <summary>
        /// 編集するブロックエレメントを設定します。
        /// </summary>
        /// <param name="blockElement">編集するブロックエレメント</param>
        void SetBlockElement(BlockElementBase blockElement);

        /// <summary>
        /// 編集中のブロックエレメントを取得します。
        /// </summary>
        /// <returns>編集中のブロックエレメントを返します。</returns>
        BlockElementBase GetBlockElement();
    }
}
