﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Blocks.Core;
using EffectCombiner.Primitives.Generation;
using Renderer2D.Core;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Blocks.BlockRenderers
{
    public abstract class BlockRendererBase
    {
        public abstract ISize Measure(Renderer renderer, BlockRenderInfo renderInfo, BlockDefinition definition, IRectangle blockSize);
        public abstract void Render(Renderer renderer, BlockRenderInfo renderInfo, BlockDefinition definition, IRectangle blockSize);
    }
}
