﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing.Drawing2D;
using EffectCombiner.Primitives.Generation;
using Renderer2D.Core;

namespace EffectCombiner.Primitives.Blocks.BlockHitTesters
{
    public class BlockElementHitTester : PathBlockHitTesterBase
    {
        public void RecomputeHitTestPaths(EffectBlockElementBase blockElement)
        {
            if (blockElement == null)
                throw new ArgumentNullException("blockElement");

            SetBlockPath(new Size(blockElement.Width, blockElement.Height));

            ClearInputs();
            foreach (var pos in blockElement.BlockRenderInfo.InputPlugPositions)
                AddInputPath(pos.X, pos.Y);

            ClearOutputs();
            foreach (var pos in blockElement.BlockRenderInfo.OutputPlugPositions)
                AddOutputPath(pos.X, pos.Y);
        }

        private void SetBlockPath(ISize blockSize)
        {
            var blockPath = new GraphicsPath();

            const float x0 = 0.0f;
            var x1 = (float)Globals.VisualResources.RegularBlockRadiusX;
            var x2 = (float)(blockSize.Width - Globals.VisualResources.RegularBlockRadiusX);
            var x3 = (float)blockSize.Width;
            const float y0 = 0.0f;
            var y1 = (float)Globals.VisualResources.RegularBlockRadiusY;
            var y2 = (float)(blockSize.Height - Globals.VisualResources.RegularBlockRadiusY);
            var y3 = (float)blockSize.Height;
            var arcWidth = (float)(2.0 * Globals.VisualResources.RegularBlockRadiusX);
            var arcHeight = (float)(2.0 * Globals.VisualResources.RegularBlockRadiusY);
            const float cx1 = x0;
            const float cy1 = y0;
            var cx2 = x3 - arcWidth;
            var cy2 = y3 - arcHeight;

            blockPath.StartFigure();
            blockPath.AddLine(x1, y0, x2, y0);
            blockPath.AddArc(cx2, cy1, arcWidth, arcHeight, 270.0f, 90.0f);
            blockPath.AddLine(x3, y1, x3, y2);
            blockPath.AddArc(cx2, cy2, arcWidth, arcHeight, 0.0f, 90.0f);
            blockPath.AddLine(x2, y3, x1, y3);
            blockPath.AddArc(cx1, cy2, arcWidth, arcHeight, 90.0f, 90.0f);
            blockPath.AddLine(x0, y2, x0, y1);
            blockPath.AddArc(cx1, cy1, arcWidth, arcHeight, 180.0f, 90.0f);
            blockPath.CloseFigure();

            SetBlockPath(blockPath);
        }

        private void AddInputPath(double cx, double cy)
        {
            var x = (float)(cx - Globals.VisualResources.PlugRadius);
            var y = (float)(cy - Globals.VisualResources.PlugRadius);
            var diameter = (float)(Globals.VisualResources.PlugRadius * 2.0);

            var inputPath = new GraphicsPath();
            inputPath.AddEllipse(x, y, diameter, diameter);

            AddInputPath(inputPath);
        }

        private void AddOutputPath(double cx, double cy)
        {
            var x = (float)(cx - Globals.VisualResources.PlugRadius);
            var y = (float)(cy - Globals.VisualResources.PlugRadius);
            var diameter = (float)(Globals.VisualResources.PlugRadius * 2.0);

            var outputPath = new GraphicsPath();
            outputPath.AddEllipse(x, y, diameter, diameter);

            AddOutputPath(outputPath);
        }
    }
}
