﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation
{
    /// <summary>
    /// 定数ブロックです。
    /// </summary>
    public class UserDefinition : EffectBlockDefinition
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="blockDefinition">定数の型</param>
        public UserDefinition(BlockDefinition blockDefinition)
            : base(blockDefinition)
        {
            this.ParameterText = "Value";
        }

        /// <summary>
        /// 編集ができるブロックかどうか
        /// </summary>
        public bool CanEditValue
        {
            get
            {
                var shaderType = (ShaderTypeDefinition)CurrentFunctionDefinition.ReturnType;
                if (shaderType.TypeString == "void" ||
                    this.Uniform == null ||
                    this.Uniform.Type == "file")
                {
                    return false;
                }

                return true;
            }
        }

        /// <summary>
        /// ユーザ定義変数のパラメータです。
        /// </summary>
        public string ParameterText { get; set; }
    }
}
