﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;
using ShaderGenerator.GLSL;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class DotProductOperatorDefinitionSet : BuiltInFunctionDefinitionSet
    {
        public DotProductOperatorDefinitionSet()
            : base(
            "dot",
            "Dot Product",
            "{00334C26-BA23-4295-8647-71B864EE5DFD}",
            new[] { "v1", "v2" },
            new[]
            {
                new[] { "int", "ivec2", "ivec2" },
                new[] { "int", "ivec3", "ivec3" },
                new[] { "int", "ivec4", "ivec4" },
                new[] { "uint", "uvec2", "uvec2" },
                new[] { "uint", "uvec3", "uvec3" },
                new[] { "uint", "uvec4", "uvec4" },
                new[] { "float", "vec2", "vec2" },
                new[] { "float", "vec3", "vec3" },
                new[] { "float", "vec4", "vec4" },
                new[] { "double", "dvec2", "dvec2" },
                new[] { "double", "dvec3", "dvec3" },
                new[] { "double", "dvec4", "dvec4" },
            })
        {
        }
    }
}
