﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace EffectCombiner.Editor.Controls
{
    //
    // http://social.msdn.microsoft.com/forums/en-US/csharpgeneral/thread/a07c453a-c5dd-40ed-8895-6615cc808d91/
    //
    public class WatermarkTextBox : TextBox
    {
        private string watermark;

        public string Watermark
        {
            get { return watermark; }
            set
            {
                watermark = value;
                UpdateWatermark();
            }
        }

        private void UpdateWatermark()
        {
            if (IsHandleCreated == false || string.IsNullOrWhiteSpace(watermark))
                return;

            var mem = Marshal.StringToHGlobalUni(watermark);
            SendMessage(Handle, 0x1501, (IntPtr)1, mem);
            Marshal.FreeHGlobal(mem);
        }

        protected override void OnHandleCreated(EventArgs e)
        {
            base.OnHandleCreated(e);
            UpdateWatermark();
        }

        [DllImport("user32.dll", EntryPoint = "SendMessageW")]
        private static extern IntPtr SendMessage(IntPtr hWnd, int msg, IntPtr wp, IntPtr lp);
    }
}
