﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using EffectCombiner.Primitives.Blocks.BlockRenderers;
using EffectCombiner.Primitives.Extensions;
using EffectCombiner.Primitives.Generation;
using EffectDefinitions;
using Renderer2D.Core;
using Renderer2D.Core.WinForms;

namespace EffectCombiner.Editor.Controls
{
    public class BlockPreviewRenderSurface : RenderControl
    {
        private readonly BlockPreviewForm parent;
        private readonly BlockRenderInfo blockRenderInfo;
        private readonly BlockRendererBase blockRenderer;

        public BlockPreviewRenderSurface(BlockPreviewForm parent)
        {
            if (parent == null)
                throw new ArgumentNullException("parent");

            this.parent = parent;

            blockRenderInfo = new BlockRenderInfo();
            blockRenderer = new RegularBlockRenderer();
        }

        private readonly object syncRoot = new object();

        private ISize blockSize;

        private BlockDefinition blockDefinition;
        public BlockDefinition BlockDefinition
        {
            get
            {
                lock (syncRoot)
                    return blockDefinition;
            }
            set
            {
                lock (syncRoot)
                {
                    blockDefinition = value;
                    blockRenderInfo.Initialize(blockDefinition);
                    blockSize = blockRenderer.Measure(Renderer, blockRenderInfo, blockDefinition, null);
                }

                IPoint[] inputs;
                IPoint[] outputs;

                blockDefinition.GetPlugPositions(blockSize, out inputs, out outputs);
                blockRenderInfo.InputPlugPositions = inputs.Select(p => new System.Drawing.PointF((float)p.X, (float)p.Y)).ToArray();
                blockRenderInfo.OutputPlugPositions = outputs.Select(p => new System.Drawing.PointF((float)p.X, (float)p.Y)).ToArray();

                parent.ClientSize = new System.Drawing.Size((int)blockSize.Width + 16, (int)blockSize.Height + 16);
                parent.Invalidate();
            }
        }

        protected override void OnRender()
        {
            Renderer.Clear(System.Drawing.Color.White.ToRendererColor());

            BlockDefinition localBlockDefinition;
            lock (syncRoot)
                localBlockDefinition = blockDefinition;

            var originalMatrix = Renderer.Transform ?? Matrix.Identity;
            Renderer.Transform = Matrix.Identity;

            blockRenderer.Render(Renderer, blockRenderInfo, localBlockDefinition, new Rectangle(new Point(7.0, 7.0), blockSize));

            Renderer.Transform = originalMatrix;
        }
    }
}
