﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EffectCombiner.BlockAssistant
{
    public enum ReportLevel
    {
        Information,
        Warning,
        Error,
    }

    public class Report : IDisposable
    {
        private Func<string> messageFunc;
        public string Message { get { return messageFunc != null ? messageFunc() : string.Empty; } }
        public ReportLevel Level { get; private set; }
        public Exception Exception { get; private set; }

        public Report(Func<string> messageFunc, ReportLevel level, Exception ex)
        {
            if (messageFunc == null)
                throw new ArgumentNullException(string.Format(Localization.Messages.EXCEPTION_INVALID_ARGUMENT, "messageFunc"));

            this.messageFunc = messageFunc;
            Level = level;
            Exception = ex;
        }

        public void Dispose()
        {
            messageFunc = null;
        }
    }

    public class ParseReportListViewItem : ListViewItem, IDisposable
    {
        public Report Report { get; private set; }

        public ParseReportListViewItem(Report report)
        {
            if (report == null)
                throw new ArgumentNullException("report");

            Report = report;
            ImageIndex = (int)Report.Level;
            SubItems.Add("");

            UpdateData();
        }

        private void UpdateData()
        {
            SubItems[1].Text = Report.Message;
        }

        public void Dispose()
        {
            if (Report != null)
                Report.Dispose();
            Report = null;
        }
    }
}
