/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//=============================================================================
// include
//=============================================================================
#define Rez 1

#include "PIDefines.h"
#include "PIActions.h"

#include "NintendoSliceInfoScripting.h"

#include "PIGeneral.h"
#include "PIUtilities.r"

//=============================================================================
// PiPL resource
//=============================================================================
resource 'PiPL' (ResourceID, plugInName " PiPL", purgeable)
{
    {
        Kind { Export },
        Name { plugInName },
        //Category { vendorName },
        Category { PSHidden },
        Version { (latestFilterVersion << 16 ) | latestFilterSubVersion },

        CodeWin64X86 { "PluginMain" },

        // ClassID, eventID, aete ID, uniqueString:
        HasTerminology { plugInClassID, plugInEventID, ResourceID, plugInUniqueID },

        SupportedModes
        {
            noBitmap,
            doesSupportGrayScale,
            doesSupportIndexedColor,
            doesSupportRGBColor,
            noCMYKColor,
            noHSLColor,
            noHSBColor,
            noMultichannel,
            noDuotone,
            noLABColor
        },

        EnableInfo { "in (PSHOP_ImageMode, GrayScaleMode, RGBMode, IndexedMode)" },
    }
};

//=============================================================================
// dictionary (scripting) resource
//=============================================================================
resource 'aete' (ResourceID, plugInName " dictionary", purgeable)
{
    1, 0, english, roman,                                   /* aete version and language specifiers */
    {
        vendorName,                                         /* vendor suite name */
        "Slice Information Export",                         /* optional description */
        plugInSuiteID,                                      /* suite ID */
        1,                                                  /* suite code, must be 1 */
        1,                                                  /* suite level, must be 1 */
        {},                                                 /* structure for filters */
        {                                                   /* non-filter plug-in class here */
            plugInName,                                     /* unique class name */
            plugInClassID,                                  /* class ID, must be unique or Suite ID */
            plugInAETEComment,                              /* optional description */
            {                                               /* define inheritance */
                "<Inheritance>",                            /* must be exactly this */
                keyInherits,                                /* must be keyInherits */
                classExport,                                /* parent: Export, Import, Export */
                "parent class export",                      /* optional description */
                flagsSingleProperty,                        /* if properties, list below */

                "in",                                       /* our path */
                keyIn,                                      /* common key */
                typePlatformFilePath,                       /* correct path for platform */
                "file path",                                /* optional description */
                flagsSingleProperty,

                "Image Only",                               /* parameter name */
                nnSliceInfoKeyImageOnly,                    /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "image only",                               /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */
            },
            {}, /* elements (not supported) */
            /* class descriptions */
        },
        {}, /* comparison ops (not supported) */
        {}  /* any enumerations */
    }
};

