/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//=============================================================================
// include
//=============================================================================
#ifdef __POWERPC__
    #if TARGET_CARBON
        #include "PIRezMacCarbon.h"
    #else
        #include "PIRezMac.h"
    #endif
    #define PRAGMA_ONCE 0
#else
    #define Rez 1
#endif

#include "PIDefines.h"
#include "PIActions.h"

#include "NintendoFtxScripting.h"

#ifdef __PIWin__
    #include "PIGeneral.h"
    #include "PIUtilities.r"
    #if (PS_API_VERSION <= 900)
        #include "WinDialogUtils.r"
    #endif
#else
    #include "Types.r"
    #include "SysTypes.r"
    #include "PIGeneral.r"
    #include "PIUtilities.r"
    #if (PS_API_VERSION <= 900)
        #include "DialogUtilities.r"
    #endif
#endif

//=============================================================================
// PiPL resource
//=============================================================================
resource 'PiPL' (ResourceID, plugInName " PiPL", purgeable)
{
    {
        Kind { ImageFormat },
        Name { plugInName },
        Version { (latestFormatVersion << 16) | latestFormatSubVersion },
        Priority { 24 }, // 傫DAȂ Name ̃At@xbĝقD

        #ifdef __PIWin__
            #if defined(_WIN64)
                CodeWin64X86 { "PluginMain" },
            #else
                CodeWin32X86 { "PluginMain" },
            #endif
        #elif TARGET_CARBON
            CodeCarbonPowerPC { 0, 0, "" },
        #else
            CodePowerPC { 0, 0, "" },
        #endif

        // ClassID, eventID, aete ID, uniqueString:
        HasTerminology { plugInClassID, plugInEventID, ResourceID, plugInUniqueID },

        SupportedModes
        {
            noBitmap,
            doesSupportGrayScale,
            doesSupportIndexedColor,
            doesSupportRGBColor,
            noCMYKColor,
            noHSLColor,
            noHSBColor,
            noMultichannel,
            noDuotone,
            noLABColor
        },
        //EnableInfo { "in (PSHOP_ImageMode, GrayScaleMode, RGBMode, IndexedMode)" },
        EnableInfo { "in (PSHOP_ImageMode, GrayScaleMode, RGBMode, IndexedMode, Gray32Mode, RGB96Mode)" },

        FmtFileType { 'FTX ', '8BIM' },
        //ReadTypes { { '8B1F', '    ' } },
        FilteredTypes { { '8B1F', '    ' } },
        //ReadExtensions { { 'FTXB', 'FTXA' } }, // Ŏw肵̂̓tB^[Ă΂܂B
        WriteExtensions { { 'FTXB', 'FTXA' } }, // gqw肵ȂꍇAŏ̂̂t܂B
        FilteredExtensions { { 'FTXB', 'FTXA' } }, // Ŏw肵̂̓tB^[Ă΂܂B

        FormatFlags { fmtSavesImageResources, fmtCanRead, fmtCanWrite, fmtCanWriteIfRead, fmtCanWriteTransparency, fmtCanCreateThumbnail },
        FormatMaxSize { { 32767, 32767 } },

        FormatMaxChannels { {   1, 24, 24, 24, 24, 24,
                               24, 24, 24, 24, 24, 24 } },

        // ĂƗႦ΃O[XP[ 3 ch ȏ̂Ƃ
        // ǔ`IvVł͕ۑłȂf[^܂܂Ă܂Bv
        // ƕ\AgStuff->planes  1 ɂȂ
        //FormatMaxChannels { {   1,  2,  2,  4, 24, 24,
        //                     24, 24, 24, 24, 24, 24 } },

        // fmtCanWriteTransparency ̂Ƃ GrayScale  RGB ̃`l 1 ₷
        //FormatMaxChannels { {   1,  3,  2,  5, 24, 24,
        //                     24, 24, 24, 24, 24, 24 } },

        FormatICCFlags { iccCannotEmbedGray, iccCannotEmbedIndexed, iccCannotEmbedRGB, iccCannotEmbedCMYK }
    }
};

//=============================================================================
// PiMI resource (kept for backward compatibility)
//=============================================================================
resource 'PiMI' (ResourceID, plugInName " PiMI", purgeable)
{
    latestFormatVersion,    /* Version, subVersion, and priority of the interface */
    latestFormatSubVersion,
    0,
    supportsGrayScale +
    supportsIndexedColor +
    supportsRGBColor,
    '    ',                     /* Required host */

    {
        canRead,
        cannotReadAll,
        canWrite,
        canWriteIfRead,
        savesResources,
        {  1, 16, 16, 16,       /* Maximum # of channels for each plug-in mode */
          16, 16, 16, 16,
          16, 16,  0,  0,
           0,  0,  0,  0 },
        32767,              /* Maximum rows allowed in document */
        32767,              /* Maximum columns allowed in document */
        '8B1F',             /* The file type if we create a file. */
        '8BIM',             /* The creator type if we create a file. */
        {                   /* The type-creator pairs supported. */
            '8B1F', '    '
        },
        {                   /* The extensions supported. */
        }
    },

};

//=============================================================================
// dictionary (scripting) resource
//=============================================================================
resource 'aete' (ResourceID, plugInName " dictionary", purgeable)
{
    1, 0, english, roman,                                   /* aete version and language specifiers */
    {
        vendorName,                                         /* vendor suite name */
        "ftx Format",                                       /* optional description */
        plugInSuiteID,                                      /* suite ID */
        1,                                                  /* suite code, must be 1 */
        1,                                                  /* suite level, must be 1 */
        {},                                                 /* structure for filters */
        {                                                   /* non-filter plug-in class here */
            plugInName,                                     /* unique class name */
            plugInClassID,                                  /* class ID, must be unique or Suite ID */
            plugInAETEComment,                              /* optional description */
            {                                               /* define inheritance */
                "<Inheritance>",                            /* must be exactly this */
                keyInherits,                                /* must be keyInherits */
                classFormat,                                /* parent: Format, Import, Export */
                "parent class format",                      /* optional description */
                flagsSingleProperty,                        /* if properties, list below */

                "Config",                                   /* parameter name */
                nnFormatKeyConfigName,                      /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "config",                                   /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Hint",                                     /* parameter name */
                nnFormatKeyHint,                            /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "hint",                                     /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Linear",                                   /* parameter name */
                nnFormatKeyLinearFlag,                      /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "linear",                                   /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Format",                                   /* parameter name */
                nnFormatKeyFormat,                          /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "format",                                   /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Weighted Compress",                        /* parameter name */
                nnFormatKeyWeightedCompress,                /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "weighted compress",                        /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Swizzle",                                  /* parameter name */
                nnFormatKeyInitialSwizzle,                  /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "swizzle",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "MipMap Level",                             /* parameter name */
                nnFormatKeyMipLevel,                        /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "mipmap level",                             /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Mip Gen Filter",                           /* parameter name */
                nnFormatKeyMipGenFilter,                    /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "mip gen filter",                           /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Dimension",                                /* parameter name */
                nnFormatKeyDimension,                       /* parameter key ID */
                nnFormatTypeDimension,                      /* parameter type ID */
                "dimension",                                /* optional description */
                flagsOptionalEnumeratedParameter,           /* parameter flags */

                "Component Selection",                      /* parameter name */
                nnFormatKeyCompSel,                         /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "component selection",                      /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Merge",                                    /* parameter name */
                nnFormatKeyMerge,                           /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "merge",                                    /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Overwrite Input",                          /* parameter name */
                nnFormatKeyOverwriteInput,                  /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "overwrite input",                          /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Comment",                                  /* parameter name */
                nnFormatKeyCommentText,                     /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "comment",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Crop",                                     /* parameter name */
                nnFormatKeyCrop,                            /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "crop",                                     /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Resize",                                   /* parameter name */
                nnFormatKeyResizeWH,                        /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "resize",                                   /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Resize Filter",                            /* parameter name */
                nnFormatKeyResizeFilter,                    /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "resize filter",                            /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Resize Gamma",                             /* parameter name */
                nnFormatKeyResizeGamma,                     /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "resize gamma",                             /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "From Export Texture",                      /* parameter name */
                nnFormatKeyIsExportTexture,                 /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "from export texture",                      /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Output Original Path",                     /* parameter name */
                nnFormatKeyOutputOriginalPath,              /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "output original path",                     /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */
            },
            {}, /* elements (not supported) */
            /* class descriptions */
        },
        {}, /* comparison ops (not supported) */
        {                                                   /* any enumerations */
            nnFormatTypeDimension,
            {
                "1d",
                nnFormatEnum1D,
                "1d",

                "2d",
                nnFormatEnum2D,
                "2d",

                "3d",
                nnFormatEnum3D,
                "3d",

                "cube",
                nnFormatEnumCube,
                "cube",

                "1d_array",
                nnFormatEnum1DArray,
                "1d_array",

                "2d_array",
                nnFormatEnum2DArray,
                "2d_array",
            },
        }
    }
};

