﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//=============================================================================
// include
//=============================================================================
#include "NintendoDistanceFieldScripting.h"

using namespace nn::gfx::tool::nps;

//-----------------------------------------------------------------------------
//! @brief スクリプトパラメータをリードします。
//!
//! @param[in,out] globals グローバルデータです。
//-----------------------------------------------------------------------------
OSErr ReadScriptParameters(GPtr globals)
{
    OSErr error = noErr;

    DescriptorKeyIDArray keyArray =
    {
        nnDistanceFieldKeyMaxDistance,
        nnDistanceFieldKeyEdgeWrap,
        nnDistanceFieldKeyNormalize,
        NULLID
    };

    if (DescriptorAvailable(NULL))
    {
        PIReadDescriptor token = OpenReader(keyArray);
        //RNoteTrace("read token: %x", reinterpret_cast<uint32_t>(token)); // 一度も Write されてなければ 0
        if (token)
        {
            DescriptorKeyID key = NULLID;
            DescriptorTypeID type = NULLID;
            int32 flags = 0;
            while (PIGetKey(token, &key, &type, &flags))
            {
                //RNoteTrace("key: %s", std::string(reinterpret_cast<char*>(&key), 4).c_str());
                switch (key)
                {
                    case nnDistanceFieldKeyMaxDistance:
                    {
                        int32 maxDistance;
                        error = PIGetInt(token, &maxDistance);
                        gParams->m_MaxDistance = RClampValue(
                            RParameters::DISTANCE_MIN, RParameters::DISTANCE_MAX,
                            static_cast<int>(maxDistance));
                        break;
                    }

                    case nnDistanceFieldKeyEdgeWrap:
                    {
                        Boolean edgeWrap;
                        error = PIGetBool(token, &edgeWrap);
                        gParams->m_EdgeWrap = (edgeWrap == TRUE);
                        break;
                    }

                    case nnDistanceFieldKeyNormalize:
                    {
                        Boolean normalize;
                        error = PIGetBool(token, &normalize);
                        gParams->m_Normalize = (normalize == TRUE);
                        break;
                    }
                }
            }
            error = CloseReader(&token);
            if (error == errMissingParameter)
            {
                // keyArray のキーが一部なかった場合 → エラーではない
                error = noErr;
            }
        }
        gQueryForParameters = PlayDialog();
    }

    return error;
}

//-----------------------------------------------------------------------------
//! @brief スクリプトパラメータをライトします。
//!
//! @param[in,out] globals グローバルデータです。
//-----------------------------------------------------------------------------
OSErr WriteScriptParameters(GPtr globals)
{
    OSErr error = noErr;

    if (DescriptorAvailable(NULL))
    {
        PIWriteDescriptor token = OpenWriter();
        if (token)
        {
            PIPutInt(token, nnDistanceFieldKeyMaxDistance, gParams->m_MaxDistance);
            PIPutBool(token, nnDistanceFieldKeyEdgeWrap, gParams->m_EdgeWrap);
            PIPutBool(token, nnDistanceFieldKeyNormalize, gParams->m_Normalize);

            error = CloseWriter(&token);
        }
    }

    return error;
}

