﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DccUtilitySceneLights.h"

namespace Dcc = nn::gfx::tool::dcc;

/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {

namespace
{

/*!--------------------------------------------------------------------------*
    @brief RLight の名前で比較を行う関数オブジェクトです。
 *---------------------------------------------------------------------------*/
class LightPtrNameLess
{
public:
    bool operator () (const RLight* lhs, const RLight* rhs)
    {
        return strcmp(lhs->GetName(), rhs->GetName()) < 0;
    }
};

}

//----------------------------------------------------------------------------
// コンストラクタ
RSceneLights::RSceneLights(void)
{
}

//----------------------------------------------------------------------------
// デストラクタ
RSceneLights::~RSceneLights(void)
{
    init();
}

//----------------------------------------------------------------------------
// 初期化
void RSceneLights::init(void)
{
    RLightArray::iterator it = mRLights.begin();
    while(it != mRLights.end())
    {
        delete *it;
        ++it;
    }
    mRLights.clear();
}

//----------------------------------------------------------------------------
RLight* RSceneLights::GetRLight()
{
    mRLights.push_back( new RLight );
    return mRLights.back();
}

//----------------------------------------------------------------------------
//	ライトアニメーションの出力準備をします。
void RSceneLights::PrepareAnimations( const Dcc::RExpOpt& rOpt )
{
    for (int ilit = 0; ilit < static_cast<int>(mRLights.size()); ilit++)
    {
        RLight& light = *mRLights[ilit];
        light.PrepareAnimations(rOpt);
    }
}

//----------------------------------------------------------------------------
//	中間フォーマットの<light_anim_array>タグを出力します。
void RSceneLights::OutAnims( std::ostream& os, Dcc::RDataStreamArray& dataStreams, const Dcc::RExpOpt& rOpt ) const
{
    const int ts = 0;

    // 出力する順番が名前順になるようにライトをソートします
    RLightArray outLights(mRLights);
    std::sort( outLights.begin(), outLights.end(), LightPtrNameLess() );

    // アニメーションする要素を持っているライトを数える
    int animLightSize = static_cast<int>(outLights.size());
    /*
    for (int ilit = 0; ilit < (int)outLights.size(); ++ilit)
    {
        const RLight& light = *outLights[ilit];
        //if (light.HasAnimation())
        {
            ++animLightSize;
        }
    }
    */

    // ライトがない場合は <light_anim_array> を出力しない。
    if (animLightSize > 0)
    {
        os << Dcc::RTab(ts) << "<light_anim_array length=\"" << animLightSize << "\">" << R_ENDL;
        for (int ilit = 0; ilit < animLightSize; ++ilit)
        {
            outLights[ilit]->OutAnim(os, dataStreams, ts + 1, ilit, rOpt);
        }
        os << Dcc::RTab(ts) << "</light_anim_array>" << R_ENDL;
    }
}



/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility
