﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DccUtilitySceneCameras.h"

namespace Dcc = nn::gfx::tool::dcc;

/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {

//----------------------------------------------------------------------------
// コンストラクタ
RSceneCameras::RSceneCameras(void)
{
}

//----------------------------------------------------------------------------
// デストラクタ
RSceneCameras::~RSceneCameras(void)
{
    init();
}

//----------------------------------------------------------------------------
// 初期化
void RSceneCameras::init(void)
{
    RCameraArray::iterator it = mRCameras.begin();
    while(it != mRCameras.end())
    {
        delete *it;
        ++it;
    }
    mRCameras.clear();
}

//----------------------------------------------------------------------------
RCamera* RSceneCameras::GetRCamera()
{
    mRCameras.push_back( new RCamera );
    return mRCameras.back();
}

//----------------------------------------------------------------------------
//	カメラアニメーションの出力準備をします。
void RSceneCameras::PrepareAnimations( const Dcc::RExpOpt& rOpt )
{
    for (int icam = 0; icam < static_cast<int>(mRCameras.size()); icam++)
    {
        RCamera& cam = *mRCameras[icam];
        cam.PrepareAnimations( rOpt );
    }
}

//----------------------------------------------------------------------------
//	中間フォーマットの<CameraAnimationData>タグを出力します。
void RSceneCameras::OutAnims( std::ostream& os, Dcc::RDataStreamArray& dataStreams, const Dcc::RExpOpt& rOpt ) const
{
    const int ts = 0;

    // アニメーションする要素を持っているカメラを数える
    int animCamSize = static_cast<int>(mRCameras.size());
    /*
    for (int icam=0; icam<(int)mRCameras.size(); icam++)
    {
        const RCamera& cam = *mRCameras[icam];
        if (cam.HasAnimation())
        {
            ++animCamSize;
        }
    }
    */

    // カメラがない場合は <camera_anim_array> を出力しない。
    if (animCamSize > 0)
    {
        os << Dcc::RTab(ts) << "<camera_anim_array length=\"" << animCamSize << "\">" << R_ENDL;
        for (int icam = 0; icam < static_cast<int>(mRCameras.size()); icam++)
        {
            mRCameras[icam]->OutAnim(os, dataStreams, ts + 1, icam, rOpt);
        }
        os << Dcc::RTab(ts) << "</camera_anim_array>" << R_ENDL;
    }
}


/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility
