﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// GetTransform
// CalculateByPca
// RCalcTangent

/******************************************************************************
    include
******************************************************************************/
#include "DccUtilityCommon.h"
#include "DccUtilityLogger.h"

using namespace std;
namespace Dcc = nn::gfx::tool::dcc;

/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {

/******************************************************************************
    variables
******************************************************************************/

//-----------------------------------------------------------------------------
// file version
const char* R_INTERMEDIATE_FILEVERSION = "1.3.0";

//-----------------------------------------------------------------------------
// node
const char* R_WORLD_ROOT_NAME = "Nw4cRoot";

//-----------------------------------------------------------------------------
// output file name
const char* R_OUT_FILE_NAME_NODE = "@node";

/******************************************************************************
    create folder if not exist
******************************************************************************/
bool CreateFolderIfNotExist(const std::string& folderPath)
{
    if (!Dcc::RFolderExists(folderPath))
    {
        if (!::CreateDirectoryA(folderPath.c_str(), nullptr))
        {
            char	szBuf[MAX_PATH + 256];
            sprintf( szBuf, "Can't create folder: %s", folderPath.c_str() );
            RLogger::LogMessage( szBuf );
            return false;
        }
    }
    return true;
}

/******************************************************************************
    remove folder if exist
******************************************************************************/
bool RemoveFolderIfExist(const std::string& folderPath)
{
    if (Dcc::RFolderExists(folderPath))
    {
        if (!::RemoveDirectoryA(folderPath.c_str()))
        {
            return false;
        }
    }
    return true;
}

/******************************************************************************
    copy file
******************************************************************************/
bool CopyFile(const std::string& srcPath, const std::string& dstPath)
{
    if ( CreateFolderIfNotExist( Dcc::RGetFolderFromFilePath( dstPath ) ) == false )
    {
        return false;
    }

    return ::CopyFileA( srcPath.c_str(), dstPath.c_str(), FALSE ) ? true : false;
}

/******************************************************************************
    move directory
******************************************************************************/
Dcc::RStatus MoveDirectory(
    const std::string& folderPath,
    const std::string& outFolderPath
)
{
    WIN32_FIND_DATAA findData;
    memset(&findData, 0, sizeof(findData));

    //	出力ディレクトリの作成
    if( !CreateFolderIfNotExist(outFolderPath) )
    {
        return Dcc::RStatus::FAILURE;
    }

    std::string findFile = folderPath + "*";
    HANDLE hFind = FindFirstFileA( findFile.c_str(), &findData );
    if (hFind != INVALID_HANDLE_VALUE)
    {
        do
        {
            if (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
            {
                if (strcmp(findData.cFileName, ".") != 0 &&
                    strcmp(findData.cFileName, "..") != 0)
                {
                    std::string searchFolder = folderPath + findData.cFileName;
                    std::string outFolder = outFolderPath + findData.cFileName;
                    MoveDirectory(searchFolder + "/", outFolder + "/");
                }
            }
            else
            {
                //	ファイルを移動する
                std::string srcFile = folderPath + findData.cFileName;
                std::string dstFile = outFolderPath + findData.cFileName;
                Dcc::RFileMove		move( srcFile, dstFile );
                move.Move();
            }
        } while (FindNextFileA(hFind, &findData));
        FindClose(hFind);
    }
    else
    {
        return Dcc::RStatus::FAILURE;
    }

    return Dcc::RStatus::SUCCESS;
}

/******************************************************************************
    The file name in a folder is acquired. You can use "*" and "?".
******************************************************************************/
Dcc::RStringArray GetFileNamesFromFolder( const std::string& path )
{
    Dcc::RStringArray retrunValue;

    WIN32_FIND_DATAA findFileData;
    HANDLE findfileHandle = FindFirstFileA( path.c_str(), &findFileData );

    if ( findfileHandle != INVALID_HANDLE_VALUE )
    {
        do
        {
            retrunValue.push_back( findFileData.cFileName );
        } while ( FindNextFileA( findfileHandle, &findFileData ) );

        FindClose( findfileHandle );
    }

    return retrunValue;
}

/******************************************************************************
     中間ファイルのプリセット名に使用できる文字列なら true を返します。
******************************************************************************/
bool IsValidPresetNameString( const std::string& name )
{
    if ( Dcc::RIsValidPresetNameString( name ) == false )
    {
        return false;
    }
    else if ( Dcc::RGetLowerCaseString( name ) == "none" )
    {
        return false;
    }

    return true;
}

/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility

/******************************************************************************
-------------------------------------------------------------------------------
                end of file
-------------------------------------------------------------------------------
******************************************************************************/
