﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <util/UtilGLContext.h>
#include <util/UtilError.h>
#include <util/UtilErrorCode.h>

namespace nw { namespace g3d { namespace tool {
namespace util {

GLContext* GLContext::m_Instance = nullptr;

LRESULT CALLBACK WinProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    return DefWindowProc(hWnd, message, wParam, lParam);

}

void GLContext::Init()
{
    if (!m_IsInitialized)
    {
        DWORD		style = WS_CAPTION | WS_SYSMENU | WS_BORDER | WS_MINIMIZEBOX | WS_SIZEBOX;
        style |= CS_OWNDC;
        WNDCLASS	wc;				// ウインドウクラス.
        RECT		rect;			// 指定したウインドウサイズにするために実際に指定しなければならない領域.
        int			width, height;	// 実際にCreateWindowに渡す大きさ.

        SetRect( &rect, 0, 0, 1, 1);
        AdjustWindowRect( &rect, style, FALSE );	// スタイルを計算に入れて、必要な領域を取得.

        width = rect.right - rect.left;
        height = rect.bottom - rect.top;

        // ウインドウクラス設定.
        ZeroMemory( &wc, sizeof( WNDCLASS ) );
        wc.hbrBackground	= static_cast<HBRUSH>( GetStockObject( BLACK_BRUSH ) );
        wc.hCursor			= LoadCursor( NULL, IDC_ARROW );
        wc.hInstance		= GetModuleHandle( NULL );
        wc.lpfnWndProc		= WinProc;
        wc.lpszClassName	= L"spoofing";

        if ( wc.hInstance == NULL )
        {
            // GetModuleHandle失敗.
            THROW_ERROR_INTERNAL(ERRCODE_INTERNAL, "Internal error.");
            //printf( "GetModuleHandle failed" );
        }

        if ( RegisterClass( &wc ) == 0 )
        {
            // クラス登録失敗.
            THROW_ERROR_INTERNAL(ERRCODE_INTERNAL, "Internal error.");
            //printf ( "RegisterClass failed" );
        }

        // ウインドウ作成.
        m_HWnd = CreateWindow(
            L"spoofing",	// クラス名.
            L"spoofing",	// キャプション.
            style,					// ウインドウスタイル.
            CW_USEDEFAULT,			// ウインドウ位置X.
            CW_USEDEFAULT,			// ウインドウ位置Y.
            width,					// ウインドウ幅.
            height,					// ウインドウ高さ.
            NULL,					// 親.
            NULL,					// 子.
            wc.hInstance,			// アプリケーションインスタンスハンドル.
            NULL					// ウインドウ作成データ.
            );

        if ( m_HWnd == NULL )
        {
            THROW_ERROR_INTERNAL(ERRCODE_INTERNAL, "Internal error.");
            //printf ( "CreateWindow failed" );
        }

        m_Hdc = GetDC(m_HWnd);

        // PIXELFORMATDESCRIPTOR準備.
        int pixelformat;
        PIXELFORMATDESCRIPTOR pfd;
        memset( &pfd, 0, sizeof( PIXELFORMATDESCRIPTOR ) );
        pfd.nSize			= sizeof( PIXELFORMATDESCRIPTOR );
        pfd.nVersion		= 1;
        //		pfd.dwFlags			= PFD_SUPPORT_OPENGL | PFD_GENERIC_ACCELERATED | PFD_SWAP_EXCHANGE;
        pfd.dwFlags			= PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER | PFD_GENERIC_ACCELERATED;
        pfd.iPixelType		= PFD_TYPE_RGBA;
        pfd.cColorBits		= 32;
        pfd.cDepthBits		= 24;
        pfd.cStencilBits	= 8;

        // ピクセルフォーマット取得.
        if ( ( pixelformat = ChoosePixelFormat( m_Hdc, &pfd ) ) == 0 )
        {
            ReleaseDC( m_HWnd, m_Hdc );
            DestroyWindow( m_HWnd );
            THROW_ERROR_INTERNAL(ERRCODE_INTERNAL, "Internal error.");
        }
        DescribePixelFormat( m_Hdc, pixelformat, pfd.nSize, &pfd );
        if ( !SetPixelFormat( m_Hdc, pixelformat, &pfd ) )
        {
            ReleaseDC( m_HWnd, m_Hdc );
            DestroyWindow( m_HWnd );
            THROW_ERROR_INTERNAL(ERRCODE_INTERNAL, "Internal error.");
        }

        m_Hglrc = wglCreateContext( m_Hdc );

        wglMakeCurrent( m_Hdc, m_Hglrc );

        m_IsInitialized = true;
    }
}

void GLContext::Delete()
{
    if (m_IsInitialized)
    {
        wglMakeCurrent (NULL, NULL);

        wglDeleteContext (m_Hglrc);

        ReleaseDC(m_HWnd, m_Hdc);
        DestroyWindow(m_HWnd);

        m_IsInitialized = false;
    }
}

void GLContext::MakeCurrent()
{
    if (m_IsInitialized)
    {
        wglMakeCurrent( m_Hdc, m_Hglrc );
    }
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
