﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3dif/AnimCurve.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

G3DIF_DEFINE_ENUM_TABLE(
    anim_curve, frame_type,
    S11N_DEFINE_ENUM_ID(none),
    S11N_DEFINE_ENUM_ID(frame32),
    S11N_DEFINE_ENUM_ID(frame16),
    S11N_DEFINE_ENUM_ID(frame8)
);

G3DIF_DEFINE_ENUM_TABLE(
    anim_curve, key_type,
    S11N_DEFINE_ENUM_ID(none),
    S11N_DEFINE_ENUM_ID(key32),
    S11N_DEFINE_ENUM_ID(key16),
    S11N_DEFINE_ENUM_ID(key8),
    S11N_DEFINE_ENUM_ID(key1)
);

G3DIF_DEFINE_ENUM_TABLE(
    anim_curve, wrap,
    S11N_DEFINE_ENUM_ID(clamp),
    S11N_DEFINE_ENUM_ID(repeat),
    S11N_DEFINE_ENUM_ID(mirror),
    S11N_DEFINE_ENUM_ID(relative_repeat)
);

bool elem_anim_curve::Read(const util::XMLElement* pParent)
{
    static const struct IdType { const util::LiteralStr* id; enum_curve_type type; } table[] = {
        { &tbl_identifier[id_hermite_curve], elem_anim_curve::hermite },
        { &tbl_identifier[id_linear_curve], elem_anim_curve::linear },
        { &tbl_identifier[id_step_curve], elem_anim_curve::step },
        { nullptr, elem_anim_curve::num_curve_type }
    };

    const util::XMLElement* pElem = nullptr;
    for (const IdType* pIter = &table[0]; pIter->id; ++pIter)
    {
        pElem = pParent->Child(*pIter->id);
        if (pElem)
        {
            curve_type = pIter->type;
            break;
        }
    }
    if (pElem == nullptr)
    {
        return false;
    }

    count << pElem;
    frame_type << pElem;
    key_type << pElem;
    scale << pElem;
    offset << pElem;
    pre_wrap << pElem;
    post_wrap << pElem;
    stream_index << pElem;

    return true;
}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
