﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

//--------------------------------------------------------------------------------------------------

class elem_vtx_attrib
{
public:
    G3DIF_DEFINE_ENUM(semantic_name,
        generic,
        position,
        normal,
        tangent,
        binormal,
        color,
        blendindex,
        blendweight,
        texcoord
    );

    G3DIF_DEFINE_ENUM(type,
        type_int,
        type_int2,
        type_int3,
        type_int4,
        type_uint,
        type_uint2,
        type_uint3,
        type_uint4,
        type_float,
        type_float2,
        type_float3,
        type_float4
    );

    G3DIF_DEFINE_ENUM(quantize_type,
        qtype_none,
        qtype_unorm_8,
        qtype_uint_8,
        qtype_snorm_8,
        qtype_sint_8,
        qtype_uint_to_float_8,
        qtype_sint_to_float_8,
        qtype_unorm_4_4,
        qtype_unorm_16,
        qtype_uint_16,
        qtype_snorm_16,
        qtype_sint_16,
        qtype_float_16,
        qtype_uint_to_float_16,
        qtype_sint_to_float_16,
        qtype_unorm_8_8,
        qtype_uint_8_8,
        qtype_snorm_8_8,
        qtype_sint_8_8,
        qtype_uint_to_float_8_8,
        qtype_sint_to_float_8_8,
        qtype_uint_32,
        qtype_sint_32,
        qtype_float_32,
        qtype_unorm_16_16,
        qtype_uint_16_16,
        qtype_snorm_16_16,
        qtype_sint_16_16,
        qtype_float_16_16,
        qtype_uint_to_float_16_16,
        qtype_sint_to_float_16_16,
        qtype_float_10_11_11,
        qtype_unorm_8_8_8_8,
        qtype_uint_8_8_8_8,
        qtype_snorm_8_8_8_8,
        qtype_sint_8_8_8_8,
        qtype_uint_to_float_8_8_8_8,
        qtype_sint_to_float_8_8_8_8,
        qtype_unorm_10_10_10_2,
        qtype_uint_10_10_10_2,
        qtype_snorm_10_10_10_2,
        qtype_sint_10_10_10_2,
        qtype_uint_32_32,
        qtype_sint_32_32,
        qtype_float_32_32,
        qtype_unorm_16_16_16_16,
        qtype_uint_16_16_16_16,
        qtype_snorm_16_16_16_16,
        qtype_sint_16_16_16_16,
        qtype_float_16_16_16_16,
        qtype_uint_to_float_16_16_16_16,
        qtype_sint_to_float_16_16_16_16,
        qtype_uint_32_32_32,
        qtype_sint_32_32_32,
        qtype_float_32_32_32,
        qtype_uint_32_32_32_32,
        qtype_sint_32_32_32_32,
        qtype_float_32_32_32_32
        );

    elem_vtx_attrib()
        : name()
        , hint()
        , type(type_float4)
        , quantize_type(qtype_none)
        , count(0)
        , stream_index(-1)
        , stream()
        , semantic_name(generic)
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(vtx_attrib);

    G3DIF_DEFINE_ATTRIB(std::string, name);
    G3DIF_DEFINE_ATTRIB(std::string, hint);
    G3DIF_DEFINE_ATTRIB(enum_type, type);
    G3DIF_DEFINE_ATTRIB(enum_quantize_type, quantize_type);
    G3DIF_DEFINE_ATTRIB(int, count);
    G3DIF_DEFINE_ATTRIB(int, stream_index);

    DataStream stream;
    enum_semantic_name semantic_name;

    // 文字列から型を取得します。
    static enum_type GetType(std::string str);

    // 型から文字列を取得します。
    static std::string GetType(enum_type type);

    // 大きい量子化型を取得します。
    static enum_quantize_type Compare(enum_quantize_type lhs, enum_quantize_type rhs);
};

class elem_input
{
public:
    elem_input() : attrib_index(-1), attrib(nullptr) {}

    G3DIF_DEFINE_ELEM_ARRAY(input);

    G3DIF_DEFINE_ATTRIB(int, attrib_index);

    elem_vtx_attrib* attrib; // 参照解決後に利用可。
};

class elem_vtx_buffer
{
public:
    elem_vtx_buffer() : input_array() {}

    G3DIF_DEFINE_ELEM_ARRAY(vtx_buffer);

    std::vector<elem_input> input_array;
};

class elem_lod_offset
{
public:
    elem_lod_offset() : count(0) {}

    G3DIF_DEFINE_ELEM(lod_offset);

    G3DIF_DEFINE_ATTRIB(int, count);

    std::vector<int> lodOffset;
};

//--------------------------------------------------------------------------------------------------

class elem_vertex
{
public:
    elem_vertex() : lod_offset(), vtx_attrib_array(), vtx_buffer_array(), positions() {}

    G3DIF_DEFINE_ELEM_ARRAY(vertex);

    void PostProcess(std::vector<elem_stream>& stream_array);
    void PostBinaryProcess(StreamArray& streamArray);

    util::Optional<elem_lod_offset> lod_offset;
    std::vector<elem_vtx_attrib> vtx_attrib_array;
    std::vector<elem_vtx_buffer> vtx_buffer_array;

    std::vector<util::Vec3_t> positions;
    std::vector<std::vector<int>> boneLists;
    std::vector<util::RefBoneWeight> boneIndices;

private:
    void CheckType();
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
