﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/AnimCurve.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_shape_anim_target
{
public:
    elem_shape_anim_target()
        : key_shape_name()
        , base_value(0.0f)
        , curve()
    {
    }

    G3DIF_DEFINE_ELEM(shape_anim_target);

    G3DIF_DEFINE_ATTRIB(std::string, key_shape_name);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_vertex_shape_anim
{
public:

    elem_vertex_shape_anim()
        : shape_name()
        , base_name()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(vertex_shape_anim);

    G3DIF_DEFINE_ATTRIB(std::string, shape_name);
    G3DIF_DEFINE_ATTRIB(std::string, base_name);

    std::vector<elem_shape_anim_target> shape_anim_target_array;
};

class elem_shape_anim_info
{
public:

    elem_shape_anim_info()
        : frame_count(0)
        , loop(true)
    {
    }

    G3DIF_DEFINE_ELEM(shape_anim_info);

    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
};

class elem_shape_anim
{
public:

    elem_shape_anim()
        : name()
        , path()
        , shape_anim_info()
        , vertex_shape_anim_array()
        , stream_array()
        , user_data_array()
    {
    }

    G3DIF_DEFINE_ELEM(shape_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_shape_anim_info shape_anim_info;
    std::vector<elem_vertex_shape_anim> vertex_shape_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
