﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Include/GlobalOptionParser.h"

namespace nn {
namespace g3dTool {

GlobalOptionParser::GlobalOptionParser()
{
    SetArgs( &m_InputArgArray );

    // コマンドラインオプションを定義します。
    {
        SetOption( m_OptionDefinitions.version.Define(
            false, "version", "Display version information and exit." ) );
        SetOption( m_OptionDefinitions.help.Define(
            false, 'h', "help", "Display this help and exit." ) );
        SetOption( m_OptionDefinitions.silent.Define(
            false, 's', "silent", "Don't display progress information." ) );
        SetOption( m_OptionDefinitions.preProcess.Define(
            false, "preprocess", "Internal use." ) );	// 非公開オプションです。全マクロを展開してコンパイラにソースを渡します。
        SetOption( m_OptionDefinitions.verify.Define(
            false, "verify", "Verify intermediate files and show the error message." ) );
        SetOption( m_OptionDefinitions.unifiedAnnotation.Define(
            false, "unified-annotation", "Unify annotations which differ between stages." ) );	// 頂点シェーダ、フラグメントシェーダなどステージ間でアノテーション表記が異なる場合に、頂点シェーダ ＜ ジオメトリシェーダ ＜ フラグメントシェーダ の順で上書きを行います。
        SetOption( m_OptionDefinitions.rootConfig.Define(
            false, "root-config", "Specify the rootpath of config files." ) );
        SetOption( m_OptionDefinitions.rootDefinition.Define(
            false, "root-definition", "Specify the rootpath of definition files." ) );
        SetOption( m_OptionDefinitions.output.Define(
            false, 'o', "output", "Specify the output file name. You must specify this option in case you input multiple files." ) );	// 拡張子付きの出力ファイル名を指定します。入力ファイルにシェーダ設定ファイルがある場合、指定された名前のシェーダ定義ファイルを出力します。
        SetOption( m_OptionDefinitions.forceVariation.Define(
            false, "force-variation", "Consider branch options to be false forcibly." ) );
        SetOption( m_OptionDefinitions.dumpShaderSource.Define(
            false, "dump-shader-source", "Dump shader keys, sources, assemblies, symbols and statistics infomations to the specified directory." ) );
        SetOption( m_OptionDefinitions.dumpStatisticsInformation.Define(
            false, "dump-statistics-information", "Dump shader keys and statistics infomations to the specified directory."));
        SetOption( m_OptionDefinitions.glslVersion.Define(
            false, "glsl-version", "Specify glsl version." ) );
        SetOption( m_OptionDefinitions.defineMacro.Define(
            false, "define-macro", "Internal option." ) );	// プリプロセッサマクロを定義します。
        SetOption( m_OptionDefinitions.autoExtract.Define(
            false, "auto-extract", "Internal option." ) );	// 非公開オプションです。fsc に全バリエーションを記載していなくても fsd の生成をします。branch=true, choice=\"*\"で fsd が生成されます。
        SetOption( m_OptionDefinitions.apiType.Define(
            false, "api-type", "Graphics api type to be used." ) );
        SetOption( m_OptionDefinitions.codeType.Define(
            false, "code-type", "Specify the shader output code type." ) );
        SetOption( m_OptionDefinitions.debugInfoLevel.Define(
            false, "debug-info-level", "Set the debug info level." ) );
        SetOption( m_OptionDefinitions.debugInfoDirectory.Define(
            false, "debug-info-directory", "Save the debug info data to the specified directory." ) );
        SetOption( m_OptionDefinitions.shaderCacheDirectory.Define(
            false, "shader-cache-directory", "Save/Load the compiled result to/from the specified directory." ) );
        SetOption(m_OptionDefinitions.shaderCacheWriteDirectory.Define(
            false, "shader-cache-write-directory", "Save the compiled result to the specified directory."));
        SetOption(m_OptionDefinitions.shaderCacheReadDirectory.Define(
            false, "shader-cache-read-directory", "Load the compiled result from the specified directory."));
        SetOption( m_OptionDefinitions.glslExtension.Define(
            false, "glsl-extension", "Specify the GLSL extension to include at the start of the source code." ) );
        SetOption( m_OptionDefinitions.usePreprocessorVariation.Define( false, "use-preprocessor-variation", "Use preprocessor variation." ) );
        SetOption( m_OptionDefinitions.decomposeBinary.Define( false, "decompose-binary", "Decompose binary." ) );
        SetOption( m_OptionDefinitions.jobs.Define( false, "jobs", "Specify the number of thread." ) );
        SetOption( m_OptionDefinitions.glslcOptionFlags.Define( false, "glslc-option-flags", "Specify GLSLCoptionFlags." ) );
        SetOption( m_OptionDefinitions.gfxShaderConverterOptions.Define(false, "gfx-shader-converter-options", "Specify options for (gfx)ShaderConverter.exe."));
        SetOption( m_OptionDefinitions.variationBeginRatio.Define( false, "variation-begin-ratio",
            "Compile only the shader variation in the range of [variation-begin-ratio, variation-end-ratio] ( The range of all generated shader variations is [0.0, 1.0] )." ) );
        SetOption( m_OptionDefinitions.variationEndRatio.Define( false, "variation-end-ratio",
            "Compile only the shader variation in the range of [variation-begin-ratio, variation-end-ratio] ( The range of all generated shader variations is [0.0, 1.0] )." ) );
        SetOption( m_OptionDefinitions.skipConvert.Define( false, "skip-convert", "Compile the shader but skip the binary conversion." ) );
        SetOption( m_OptionDefinitions.mergeShaderArchiveFile.Define(false, "merge-shader-archive-file", "Specifies shader archive file name which the result merged shader archive contains."));
    }
}

}
}
