﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):

	# fsd 以外の <nw4f_3dif> version を 3.4.0 に変更します。
	if not doc.SelectSingleNode("/nw4f_3dif/shader_definition"):
		version = doc.SelectSingleNode("/nw4f_3dif/@version")
		version.Value = "3.4.0"

	# モデルの更新
	model = doc.SelectSingleNode("/nw4f_3dif/model")
	if model:
		UpdateModel(doc, model)
		return

	# シェーダパラメータアニメの更新
	shader_param_anim = doc.SelectSingleNode("/nw4f_3dif/shader_param_anim")
	if shader_param_anim:
		UpdateShaderParamAnim(doc, shader_param_anim)
		return

	# シェーダ設定の更新
	shader_config = doc.SelectSingleNode("/nw4f_3dif/shader_config")
	if shader_config:
		UpdateShaderConfig(doc, shader_config)
		return

#==========================================================
# モデルの更新
def UpdateModel(doc, model):

	# <original_texsrt> に uv_hint を空文字列で追加します。
	for original_texsrt in model.SelectNodes(
		"original_material_array/original_material/original_texsrt_array/original_texsrt"):
		original_texsrt.SetAttribute("uv_hint", "")

#==========================================================
# シェーダパラメータアニメの更新
def UpdateShaderParamAnim(doc, shader_param_anim):

	# <shader_param_anim_info> の shader_assigned を削除します。
	shader_param_anim_info = shader_param_anim.SelectSingleNode("shader_param_anim_info")
	shader_param_anim_info.RemoveAttribute("shader_assigned")

#==========================================================
# シェーダ設定の更新
def UpdateShaderConfig(doc, shader_config):

	# <shader> に material_shader を true で追加します。
	for shader in shader_config.SelectNodes("shader_array/shader"):
		shader.SetAttribute("material_shader", "true")

#==========================================================
