﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Runtime;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using nw.g3d.toollib;
using System.Resources;

namespace nw.g3d.update
{
    // 中間ファイルアップデータ
    public class g3dupdate : SimpleFilterTool<g3dupdateParams>
    {
        // エントリポイント
        public static void Main()
        {
            string path = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            ProfileOptimization.SetProfileRoot(path);
            ProfileOptimization.StartProfile(Path.GetFileNameWithoutExtension(
                Assembly.GetExecutingAssembly().Location) + ".JIT.Profile");

            var helpResourceManager = new ResourceManager("nw.g3d.update.Resources.CommandLineHelp", typeof(g3dupdate).Assembly);
            SimpleFilterToolParams.CustomDescriptionConverterFunc = (x, y) =>
            {
                return helpResourceManager.GetString(x);
            };

            g3dupdate g3dupdate = new g3dupdate();
            G3dToolUtility.Run(delegate { g3dupdate.Run(); });
        }

        // コンストラクタ
        public g3dupdate() : base("nw.g3d.update.Resources.StringResource", true) { }

        protected override void ProcessProgramArgument(g3dupdateParams param)
        {
            base.ProcessProgramArgument(param);

            this.DisableFileInfo = param.DisableFileInfo;
        }

        // ファイルパスのチェック
        protected override bool CheckFilePath(string filePath)
        {
            if (!G3dPath.IsPath(filePath)) { return false; }
            return base.CheckFilePath(filePath);
        }

        // ファイル処理
        protected override void ProcessFile(int index, string filePath)
        {
            if (G3dPath.IsStreamBinaryPath(filePath))
            {
                List<G3dStream> stream_array = new List<G3dStream>();
                bool updated;
                nw4f_3difType nw4f_3dif = IfBinaryReadUtility.Read(
                    stream_array, filePath, this.XsdBasePath, out updated);
                if (!updated) { return; }
                if (!this.DisableFileInfo) { IfFileLogUtility.SetModify(nw4f_3dif); }
                IfBinaryWriteUtility.Write(nw4f_3dif, stream_array, filePath, this.XsdBasePath);
            }
            else
            {
                bool updated;
                nw4f_3difType nw4f_3dif = IfReadUtility.Read(
                    filePath, this.XsdBasePath, out updated);
                if (!updated) { return; }
                if (!this.DisableFileInfo) { IfFileLogUtility.SetModify(nw4f_3dif); }
                IfWriteUtility.Write(nw4f_3dif, filePath);
            }
        }

        private bool DisableFileInfo;
    }
}
