﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Reflection;
using System.Runtime.ExceptionServices;
using System.Runtime.InteropServices;
using Nintendo.G3dTool.Entities;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iftexutil
{
    public class Converter : ITextureConverter
    {
        public bool IsPlatformConverterLoaded
        {
            get
            {
                return IsGenericConverterLoaded;
            }
        }

        public bool IsGenericConverterLoaded
        {
            get
            {
                return genericConverter != null;
            }
        }

        private bool isConverterLoaded = false;

        private GenericConverter genericConverter = null;
        private OriginalImageConverter originalConverter = null;

        public Converter()
        {
            originalConverter = new OriginalImageConverter();
        }

        // コンバータを返す
        // GenericConverterはデコードできないフォーマットの時に内部でOriginalImageConverterを呼び出すので、フォーマットチェックはここで行わない
        private ITextureConverter GetConverter()
        {
            if (IsGenericConverterLoaded)
            {
                return genericConverter;
            }
            else
            {
                return originalConverter ?? (originalConverter = new OriginalImageConverter());
            }
        }

        // base パスには TextureConverterEncoder.dll のディレクトリのパスを指定する
        public bool Initialize(string[] basePath)
        {
            if (isConverterLoaded)
            {
                return true;
            }

            // TextureConverterEncoder.dllのラッパーを初期化
            var texconv = new GenericConverter();
            texconv.Initialize(basePath);
            genericConverter = texconv.IsConverterLoaded ? texconv : null;
            isConverterLoaded = genericConverter != null;

            // プラットフォーム依存のコンバータがロードできないときはオリジナルイメージを使うので常にtrue
            return true;
        }

        public void Destroy()
        {
            if (IsGenericConverterLoaded)
            {
                genericConverter.Destroy();
                genericConverter = null;
            }
        }

        public string GetPlatformName(textureType texture)
        {
            return this.GetConverter().PlatformName;
        }

        public string PlatformName
        {
            get
            {
                return this.GetConverter().PlatformName;
            }
        }

        public Bitmap[] ConvertTo1d2dBitmap(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo1d2dBitmap(texture, streams);
        }

        public Bitmap[][] ConvertTo2dArrayBitmap(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo2dArrayBitmap(texture, streams);
        }

        public Bitmap[][] ConvertTo3dBitmap(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo3dBitmap(texture, streams);
        }

        public Bitmap[][] ConvertToCubeArrayBitmap(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertToCubeArrayBitmap(texture, streams);
        }

        public Bitmap[][] ConvertToCubeBitmap(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertToCubeBitmap(texture, streams);
        }

        public Bitmap[][] ConvertTo1dArrayBitmap(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo1dArrayBitmap(texture, streams);
        }

        public TextureData[] ConvertTo1d2dStream(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo1d2dStream(texture, streams);
        }

        public TextureData[][] ConvertTo3dStream(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo3dStream(texture, streams);
        }

        public TextureData[][] ConvertToCubeStream(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertToCubeStream(texture, streams);
        }

        public TextureData[][] ConvertTo1dArrayStream(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo1dArrayStream(texture, streams);
        }

        public TextureData[][] ConvertTo2dArrayStream(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertTo2dArrayStream(texture, streams);
        }

        public TextureData[][] ConvertToCubeArrayStream(textureType texture, List<G3dStream> streams)
        {
            return GetConverter().ConvertToCubeArrayStream(texture, streams);
        }

        public Bitmap[] ConvertTo1d2dBitmap(Texture texture)
        {
            return GetConverter().ConvertTo1d2dBitmap(texture);
        }

        public Bitmap[][] ConvertTo2dArrayBitmap(Texture texture)
        {
            return GetConverter().ConvertTo2dArrayBitmap(texture);
        }

        public Bitmap[][] ConvertTo3dBitmap(Texture texture)
        {
            return GetConverter().ConvertTo3dBitmap(texture);
        }

        public Bitmap[][] ConvertToCubeArrayBitmap(Texture texture)
        {
            return GetConverter().ConvertToCubeArrayBitmap(texture);
        }

        public Bitmap[][] ConvertToCubeBitmap(Texture texture)
        {
            return GetConverter().ConvertToCubeBitmap(texture);
        }

        public Bitmap[][] ConvertTo1dArrayBitmap(Texture texture)
        {
            return GetConverter().ConvertTo1dArrayBitmap(texture);
        }

        public TextureData[] ConvertTo1d2dStream(Texture texture)
        {
            return GetConverter().ConvertTo1d2dStream(texture);
        }

        public TextureData[][] ConvertTo3dStream(Texture texture)
        {
            return GetConverter().ConvertTo3dStream(texture);
        }

        public TextureData[][] ConvertToCubeStream(Texture texture)
        {
            return GetConverter().ConvertToCubeStream(texture);
        }

        public TextureData[][] ConvertTo1dArrayStream(Texture texture)
        {
            return GetConverter().ConvertTo1dArrayStream(texture);
        }

        public TextureData[][] ConvertTo2dArrayStream(Texture texture)
        {
            return GetConverter().ConvertTo2dArrayStream(texture);
        }

        public TextureData[][] ConvertToCubeArrayStream(Texture texture)
        {
            return GetConverter().ConvertToCubeArrayStream(texture);
        }
    }
}
