﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// マテリアルへの参照
    /// </summary>
    public interface IG3dMaterialReference
    {
        /// <summary>
        /// マテリアルの名前
        /// </summary>
        string mat_name { get; set; }
    }

    //=====================================================================
    public partial class shape_infoType : IG3dMaterialReference { }

    public partial class original_materialType : IG3dMaterialReference { }

    public partial class per_material_animType : IG3dMaterialReference { }

    public partial class shader_param_mat_animType : IG3dMaterialReference { }

    public partial class original_material_animType : IG3dMaterialReference { }

    public partial class tex_pattern_mat_animType : IG3dMaterialReference { }

    public partial class mat_vis_mat_animType : IG3dMaterialReference { }
}
