﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// ボーン
    /// </summary>
    public interface IG3dBone : IG3dIndexHintElement, IG3dNamedElement, IG3dCompressibleBone
    {
        /// <summary>
        /// 親ボーンの名前
        /// </summary>
        string parent_name { get; set; }

        /// <summary>
        /// リジッドボディの描画に利用されるか
        /// </summary>
        bool rigid_body { get; set; }

        /// <summary>
        /// スキニング行列のインデックス
        /// </summary>
        int[] matrix_index { get; set; }
    }

    //=====================================================================
    public partial class boneType : IG3dBone { }

    public partial class bone_animType : IG3dBone
    {
        /// <summary>
        /// 名前
        /// </summary>
        [XmlIgnore]
        public string name
        {
            get { return this.bone_name; }
            set { this.bone_name = value; }
        }
    }

    public partial class bone_vis_bone_animType : IG3dBone
    {
        /// <summary>
        /// 名前
        /// </summary>
        [XmlIgnore]
        public string name
        {
            get { return this.bone_name; }
            set { this.bone_name = value; }
        }
    }
}
