﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.IO;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// 中間ファイルの定数
    /// </summary>
    public static class G3dConstant
    {
        /// <summary>
        /// 中間ファイルバージョン
        /// </summary>
        public const string Version = "3.6.0";

        /// <summary>
        /// ルートボーンの名前
        /// </summary>
        public const string RootBoneName = "nw4f_root";

        //---------------------------------------------------------------------
        /// <summary>
        /// バイナリ中間ファイルのアライメント
        /// </summary>
        public const int BinaryAlignment = 32;

        /// <summary>
        /// ストリーム配列チャンク
        /// </summary>
        public const ulong StreamArrayChunkID = 0x616D727473643367;

        /// <summary>
        /// ストリームサブチャンク
        /// </summary>
        public const ulong StreamSubChunk = 0x20206D6165727473;

        //---------------------------------------------------------------------
        /// <summary>
        /// 頂点キャッシュサイズ
        /// </summary>
        public const int VertexCacheSize = 14;

        //=====================================================================
        /// <summary>
        /// モデル要素名
        /// </summary>
        public const string ModelElementName = "model";

        /// <summary>
        /// モデル要素
        /// </summary>
        public const string ModelElement =
            "<" + G3dConstant.ModelElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// マテリアル要素名
        /// </summary>
        public const string MaterialElementName = "material";

        /// <summary>
        /// マテリアル要素
        /// </summary>
        public const string MaterialElement =
            "<" + G3dConstant.MaterialElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// テクスチャ要素名
        /// </summary>
        public const string TextureElementName = "texture";

        /// <summary>
        /// テクスチャ要素
        /// </summary>
        public const string TextureElement =
            "<" + G3dConstant.TextureElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// スケルタルアニメーション要素名
        /// </summary>
        public const string SkeletalAnimElementName = "skeletal_anim";

        /// <summary>
        /// スケルタルアニメーション要素
        /// </summary>
        public const string SkeletalAnimElement =
            "<" + G3dConstant.SkeletalAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// マテリアルアニメーション要素名
        /// </summary>
        public const string MaterialAnimElementName = "material_anim";

        /// <summary>
        /// マテリアルアニメーション要素
        /// </summary>
        public const string MaterialAnimElement =
            "<" + G3dConstant.MaterialAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// シェーダーパラメーターアニメーション要素名
        /// </summary>
        public const string ShaderParamAnimElementName = "shader_param_anim";

        /// <summary>
        /// シェーダーパラメーターアニメーション要素
        /// </summary>
        public const string ShaderParamAnimElement =
            "<" + G3dConstant.ShaderParamAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// カラーアニメーション要素名
        /// </summary>
        public const string ColorAnimElementName =
            G3dConstant.ShaderParamAnimElementName;

        /// <summary>
        /// カラーアニメーション要素
        /// </summary>
        public const string ColorAnimElement =
            "<" + G3dConstant.ColorAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// テクスチャ SRT アニメーション要素名
        /// </summary>
        public const string TexSrtAnimElementName =
            G3dConstant.ShaderParamAnimElementName;

        /// <summary>
        /// テクスチャ SRT アニメーション要素
        /// </summary>
        public const string TexSrtAnimElement =
            "<" + G3dConstant.TexSrtAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// テクスチャパターンアニメーション要素名
        /// </summary>
        public const string TexPatternAnimElementName = "tex_pattern_anim";

        /// <summary>
        /// テクスチャパターンアニメーション要素
        /// </summary>
        public const string TexPatternAnimElement =
            "<" + G3dConstant.TexPatternAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// ボーンビジビリティアニメーション要素名
        /// </summary>
        public const string BoneVisibilityAnimElementName = "bone_visibility_anim";

        /// <summary>
        /// ボーンビジビリティアニメーション要素
        /// </summary>
        public const string BoneVisibilityAnimElement =
            "<" + G3dConstant.BoneVisibilityAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// マテリアルビジビリティアニメーション要素名
        /// </summary>
        public const string MatVisibilityAnimElementName = "mat_visibility_anim";

        /// <summary>
        /// マテリアルビジビリティアニメーション要素
        /// </summary>
        public const string MatVisibilityAnimElement =
            "<" + G3dConstant.MatVisibilityAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// シェイプアニメーション要素名
        /// </summary>
        public const string ShapeAnimElementName = "shape_anim";

        /// <summary>
        /// シェイプアニメーション要素
        /// </summary>
        public const string ShapeAnimElement =
            "<" + G3dConstant.ShapeAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// シーンアニメーション要素名
        /// </summary>
        public const string SceneAnimElementName = "scene_anim";

        /// <summary>
        /// シーンアニメーション要素
        /// </summary>
        public const string SceneAnimElement =
            "<" + G3dConstant.SceneAnimElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// シェーダー設定要素名
        /// </summary>
        public const string ShaderConfigElementName = "shader_config";

        /// <summary>
        /// シェーダー設定要素
        /// </summary>
        public const string ShaderConfigElement =
            "<" + G3dConstant.ShaderConfigElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// シェーダー定義要素名
        /// </summary>
        public const string ShaderDefinitionElementName = "shader_definition";

        /// <summary>
        /// シェーダー定義要素
        /// </summary>
        public const string ShaderDefinitionElement =
            "<" + G3dConstant.ShaderDefinitionElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// シェーダーバリエーション要素名
        /// </summary>
        public const string ShaderVariationElementName = "shader_variation";

        /// <summary>
        /// シェーダーバリエーション要素
        /// </summary>
        public const string ShaderVariationElement =
            "<" + G3dConstant.ShaderVariationElementName + ">";

        //---------------------------------------------------------------------
        /// <summary>
        /// コンバイナーシェーダー要素名
        /// </summary>
        public const string CombinerShaderElementName = "combiner_shader";

        /// <summary>
        /// コンバイナーシェーダー要素
        /// </summary>
        public const string CombinerShaderElement =
            "<" + G3dConstant.CombinerShaderElementName + ">";

        //=====================================================================
        /// <summary>
        /// 要素名テーブル
        /// </summary>
        public static readonly string[] ElementNames = new string[]
        {
            G3dConstant.ModelElementName,
            G3dConstant.TextureElementName,
            G3dConstant.SkeletalAnimElementName,
            G3dConstant.ShaderParamAnimElementName,
            G3dConstant.ColorAnimElementName,
            G3dConstant.TexSrtAnimElementName,
            G3dConstant.TexPatternAnimElementName,
            G3dConstant.BoneVisibilityAnimElementName,
            G3dConstant.MatVisibilityAnimElementName,
            G3dConstant.ShapeAnimElementName,
            G3dConstant.SceneAnimElementName,
            G3dConstant.ShaderConfigElementName,
            G3dConstant.ShaderDefinitionElementName,
            G3dConstant.ShaderVariationElementName,
        };
    }
}
