﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nw4f.tinymathlib
{
    public class int2 : IComparable
    {
        public int i0 { get; set; } = 0;
        public int i1 { get; set; } = 0;

        public int2()
        {
            i0 = 0;
            i1 = 0;
        }
        public int2(int i, int j)
        {
            i0 = i;
            i1 = j;
        }

        public override int GetHashCode()
        {
            int tmp = (i0 + 1) ^ (i1 + 1);
            return tmp;
        }

        public bool Equals(int2 rhs)
        {
            return CompareTo(rhs) == 0;
        }

        public override bool Equals(object obj)
        {
            if (obj == null) { return false; }
            return Equals(obj as int2);
        }

        public int CompareTo(object obj)
        {
            if (obj == null)
            {
                return -1;
            }
            int2 right = obj as int2;
            if (right.i0 == i0)
            {
                if (right.i1 == i1)
                {
                    return 0;
                }
                else if (right.i1 > i1)
                {
                    return -1;
                }
                else
                {
                    return 1;
                }
            }
            if (right.i0 > i0)
            {
                return -1;
            }
            return 1;
        }

        /// <summary>
        /// インデクサ
        /// </summary>
        public int this[int index]
        {
            get { return index == 0 ? i0 : i1; }
            set
            {
                if (index == 0)
                {
                    i0 = value;
                }
                else
                {
                    i1 = value;
                }
            }
        }
    }

    public class Unitlity
    {
        /// <summary>
        /// 桁数で丸める
        /// </summary>
        public static double ToRoundDown(double dValue, int iDigits)
        {
            double dCoef = System.Math.Pow(10, iDigits);

            return dValue > 0 ? System.Math.Floor(dValue * dCoef) / dCoef :
                                System.Math.Ceiling(dValue * dCoef) / dCoef;
        }
    }
}
