﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Resources;

namespace _3dIntermediateFilePlygonReduction
{
    /// <summary>
    /// 中間ファイルライブラリの文字列
    /// </summary>
    internal static class IfStrings
    {
        /// <summary>
        /// タイプコンストラクタ
        /// </summary>
        static IfStrings()
        {
            _resouceManager = new ResourceManager(
                "nw.g3d.iflib.Resources.StringResource",
                typeof(IfStrings).Assembly);
        }

        /// <summary>
        /// 文字列の取得
        /// </summary>
        /// <param name="id">文字列識別子</param>
        /// <param name="args">書式指定引数</param>
        /// <returns>文字列</returns>
        internal static string Get(string id, params object[] args)
        {
            string resource = _resouceManager.GetString(id);
            if (resource == null)
            {
                throw new Exception("String resource not found. [" + id + "]");
            }
            return string.Format(resource, args);
        }

        /// <summary>
        /// 例外の送出
        /// </summary>
        /// <param name="id">文字列識別子</param>
        /// <param name="args">書式指定引数</param>
        internal static void Throw(string id, params object[] args)
        {
            throw new Exception(_3dIntermediateFilePlygonReduction.IfStrings.Get(id, args));
        }

        private static ResourceManager _resouceManager = null;
    }
}
