﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // スケルタルアニメーションマージャ
    public static class IfSkeletalAnimMerger
    {
        // マージ用の情報
        public class IfSkeletalAnimMergerInfo
        {
            public bool IsMergeQuantize    { get; set; }

            public IEnumerable<IfMergeSrcDstPair> BoneNamePairTable{ get; set; }

            public IfSkeletalAnimMergerInfo()
            {
                IsMergeQuantize    = true;

                BoneNamePairTable = null;
            }
        }

        // マージ
        public static void Merge(
            skeletal_animType newSkeletalAnim,
            List<G3dStream> newStream,
            skeletal_animType oldSkeletalAnim,
            List<G3dStream> oldStream)
        {
            Merge(newSkeletalAnim, newStream, oldSkeletalAnim, oldStream, null);
        }

        // オプション付きのマージ
        public static void Merge(
            skeletal_animType newSkeletalAnim,
            List<G3dStream> newStream,
            skeletal_animType oldSkeletalAnim,
            List<G3dStream> oldStream,
            IfSkeletalAnimMergerInfo info)
        {
            IfSkeletalAnimMergerInfo mergeInfo;
            if (info == null)
            {
                // オプションが指定されなかった場合は全てのマージを実行し、
                // ボーンとマテリアルは全て同一名によりマージを行うデフォルトオプションを作成する。
                mergeInfo = new IfSkeletalAnimMergerInfo();
            }
            else
            {
                mergeInfo = info;
            }

            // <user_data_array> <tool_data> <user_tool_data> <comment>
            IfMergeUtility.MergeRootObject(
                newSkeletalAnim, oldSkeletalAnim,
                newStream, oldStream);

            // <skeletal_anim_info> のマージ
            if (mergeInfo.IsMergeQuantize)
            {
                skeletal_anim_infoType newInfo = newSkeletalAnim.skeletal_anim_info;
                skeletal_anim_infoType oldInfo = oldSkeletalAnim.skeletal_anim_info;
                newInfo.quantize_tolerance_scale = oldInfo.quantize_tolerance_scale;
                newInfo.quantize_tolerance_rotate = oldInfo.quantize_tolerance_rotate;
                newInfo.quantize_tolerance_translate = oldInfo.quantize_tolerance_translate;
            }

            // <bone_anim> bone_name 一致でマージ
            Dictionary<bone_animType, bone_animType> bone_animTable =
                new Dictionary<bone_animType, bone_animType>();
            if (mergeInfo.BoneNamePairTable == null)
            {
                IfMergeUtility.SetupTableByName<bone_animType>(bone_animTable,
                    newSkeletalAnim.bone_anim_array.bone_anim,
                    oldSkeletalAnim.bone_anim_array.bone_anim);
            }
            else
            {
                IfMergeUtility.SetupTableByName<bone_animType>(bone_animTable,
                    newSkeletalAnim.bone_anim_array.bone_anim,
                    oldSkeletalAnim.bone_anim_array.bone_anim,
                    mergeInfo.BoneNamePairTable);
            }

            IfMergeUtility.MergeByTable(
                newSkeletalAnim.bone_anim_array.bone_anim,
                bone_animTable,
                (newObject, oldObject) =>
                {
                    user_data_arrayType newUserData = newObject.user_data_array;
                    IfMergeUtility.MergeUserDataArray(
                        ref newUserData,
                        oldObject.user_data_array,
                        newStream, oldStream);
                    newObject.user_data_array = newUserData;
                });

            // 使用されていないストリームを削除し、
            // 残ったストリームを中間ファイルの出現順にソートする。
            StreamUtility.SortStream(newSkeletalAnim, newStream);
        }
    }
}
