﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキスト中間ファイル書き出しユーティリティ
    public static class IfTextWriteUtility
    {
        // テキスト中間ファイルの書き出し
        public static void Write(nw4f_3difType nw4f_3dif, string filePath, string xsdBasePath)
        {
            byte[] fileImage = IfTextFormatter.FormatBytes(nw4f_3dif, xsdBasePath);
            IfWriteUtility.WriteFileImage(fileImage, filePath);
        }

        // テキスト中間ファイルの書き出し
        public static void Write(nw4f_3difType nw4f_3dif, Stream stream, string xsdBasePath)
        {
            byte[] fileImage = IfTextFormatter.FormatBytes(nw4f_3dif, xsdBasePath);
            stream.Write(fileImage, 0, fileImage.Length);
        }
    }
}
