﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Diagnostics;
using System.IO;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // テキストシェーダーバリエーション中間ファイルフォーマッタ
    internal static class IfTextCombinerShaderFormatter
    {
        // shader_variation のフォーマット
        internal static void Format(TextReader rd, TextWriter wt)
        {
            // combiner_shader
            string begin = $"<{G3dConstant.CombinerShaderElementName} {rd.ReadLine()} {rd.ReadLine()} {rd.ReadLine()}";
            wt.WriteLine(begin);
            if (begin.EndsWith("/>"))
            {
                // 中身が空の combiner_shader ファイル
                return;
            }

            // material
            string material = rd.ReadLine();
            string block_array;
            if (material == "<material")
            {
                IfTextModelFormatter.FormatMaterial(rd, wt);
                block_array = rd.ReadLine();
            }
            else
            {
                block_array = material;
            }

            // block
            string connection_array;
            if (block_array == "<block_array")
            {
                Format_block_array(rd, wt);
                connection_array = rd.ReadLine();
            }
            else
            {
                connection_array = block_array;
            }

            // connection
            string uniform_array;
            if (connection_array == "<connection_array")
            {
                Format_connection_array(rd, wt);
                uniform_array = rd.ReadLine();
            }
            else
            {
                uniform_array = connection_array;
            }

            // connection
            string close;
            if (uniform_array == "<uniform_array")
            {
                Format_uniform_array(rd, wt);
                close = rd.ReadLine();
            }
            else
            {
                close = uniform_array;
            }

            Nintendo.Foundation.Contracts.Assertion.Operation.True(close == "</combiner_shader>");
            wt.WriteLine(close);
        }

        //---------------------------------------------------------------------
        // block_array のフォーマット
        private static void Format_block_array(TextReader rd, TextWriter wt)
        {
            // block_array
            wt.WriteLine("\t<block_array {0}", rd.ReadLine());

            while (true)
            {
                // TODO: フォーマット処理をちゃんと書く
                string close = rd.ReadLine();
                if (close.EndsWith("</block_array>"))
                {
                    wt.WriteLine($"\t{close}");
                    break;
                }

                wt.WriteLine($"\t\t{close}");
            }
        }

        //---------------------------------------------------------------------
        // connection_array のフォーマット
        private static void Format_connection_array(TextReader rd, TextWriter wt)
        {
            // connection_array
            wt.WriteLine("\t<connection_array {0}", rd.ReadLine());

            while (true)
            {
                // TODO: フォーマット処理をちゃんと書く
                string close = rd.ReadLine();
                if (close.EndsWith("</connection_array>"))
                {
                    wt.WriteLine($"\t{close}");
                    break;
                }

                wt.WriteLine($"\t\t{close}");
            }
        }

        //---------------------------------------------------------------------
        // uniform_array のフォーマット
        private static void Format_uniform_array(TextReader rd, TextWriter wt)
        {
            // uniform_array
            wt.WriteLine("\t<uniform_array {0}", rd.ReadLine());

            while (true)
            {
                // TODO: フォーマット処理をちゃんと書く
                string close = rd.ReadLine();
                if (close.EndsWith("</uniform_array>"))
                {
                    wt.WriteLine($"\t{close}");
                    break;
                }

                wt.WriteLine($"\t\t{close}");
            }
        }
    }
}
