﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Windows.Forms;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // 中間ファイルファイル情報ユーティリティ
    public static class IfFileLogUtility
    {
        // 作成情報を設定します
        public static void SetCreate(nw4f_3difType nw4f_3dif, string src_path)
        {
            IfFileLogUtility.SetCreate(nw4f_3dif,
                Application.ProductName, Application.ProductVersion, src_path);
        }

        // 作成情報を設定します
        public static void SetCreate(nw4f_3difType nw4f_3dif,
            string tool_name, string tool_version, string src_path)
        {
            Nintendo.Foundation.Contracts.Assertion.Argument.True(nw4f_3dif != null);

            file_infoType file_info = new file_infoType();
            // 既存の設定は破棄する
            nw4f_3dif.file_info = file_info;

            createType create = new createType();
            create.src_path = src_path;
            file_info.create = create;

            create.tool_name = tool_name;
            create.tool_version = tool_version;
        }

        // 修正情報を設定します
        public static void SetModify(nw4f_3difType nw4f_3dif)
        {
            IfFileLogUtility.SetModify(nw4f_3dif,
                Application.ProductName, Application.ProductVersion);
        }

        // 修正情報を設定します
        public static void SetModify(nw4f_3difType nw4f_3dif,
            string tool_name, string tool_version)
        {
            Nintendo.Foundation.Contracts.Assertion.Argument.True(nw4f_3dif != null);

            file_infoType file_info = nw4f_3dif.file_info;
            // ファイル情報が無ければ何もしない
            if (file_info == null) { return; }

            modifyType modify = new modifyType();
            // 既存の設定は破棄する
            file_info.modify = modify;

            modify.tool_name = tool_name;
            modify.tool_version = tool_version;
        }
    }
}
