﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // スケルタルアニメーションの完全合体ボーン圧縮
    public class IfSkeletalAnimBoneUniteAllCompressor : IfSkeletalAnimCompressor
    {
        // コンストラクタ
        public IfSkeletalAnimBoneUniteAllCompressor() :
            base("IfSkeletalAnimBoneUniteAllCompressor_Log") { }

        // プロセス
        public override string Process
        {
            get { return "compress_bone_unite_all"; }
        }

        // 圧縮
        protected override void Compress()
        {
            bone_animType[] bone_anims = this.Target.bone_anim_array.bone_anim;
            int boneAnimCount = bone_anims.Length;

            // ルートボーン以下にメッシュが存在しているか確認する
            bool hasMesh = false;
            for (int i = 1; i < boneAnimCount; i++)
            {
                bone_animType boneAnim = bone_anims[i];
                if (boneAnim.rigid_body ||
                    boneAnim.matrix_index[0] != -1 ||
                    boneAnim.matrix_index[1] != -1)
                {
                    hasMesh = true;
                    break;
                }
            }

            for (int i = 1; i < boneAnimCount; i++)
            {
                // ルートボーン以外にアニメーションが設定されているか確認する
                bone_animType boneAnim = bone_anims[i];
                SkeletalAnimCompressUtility.CheckAnimationRemoved(boneAnim);

                // binarize_scale /    binarize_rotate / binarize_translate が false のボーンアニメーションは
                // 圧縮できないのでエラーとする。
                if (!GetBinarizeFlag(boneAnim))
                {
                    IfStrings.Throw("SkeletalAnimCompress_Error_InvalidBinarizeFlag", boneAnim.name);
                }
            }

            // rigid_body 属性と matrix_index 属性の更新
            if (!bone_anims[0].rigid_body)
            {
                bone_anims[0].rigid_body = hasMesh;
                bone_anims[0].matrix_index[0] =
                bone_anims[0].matrix_index[1] = -1;
            }

            // bone_anim 配列を更新する
            bone_animType[] newBoneAnims = new bone_animType[1];
            newBoneAnims[0] = bone_anims[0];
            this.Target.bone_anim_array.length = newBoneAnims.Length;
            this.Target.bone_anim_array.bone_anim = newBoneAnims;

            // 不要になったストリームを削除する
            StreamUtility.SortStream(this.Target, this.Streams);
        }
    }
}
