﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    // ボーンビジビリティアニメーションの合体ボーン圧縮
    public class IfBoneVisibilityAnimBoneUniteCompressor
        : IfBoneVisibilityAnimCompressor
    {
        // コンストラクタ
        public IfBoneVisibilityAnimBoneUniteCompressor() :
            base("IfBoneVisibilityAnimBoneUniteCompressor_Log") { }

        // プロセス
        public override string Process
        {
            get { return "compress_bone_unite"; }
        }

        // 圧縮
        protected override void Compress()
        {
            bone_vis_bone_animType[] bone_anims =
                this.Target.bone_vis_bone_anim_array.bone_vis_bone_anim;
            int boneAnimCount = bone_anims.Length;
            BoneVisAnimInfo[] boneAnimInfos = new BoneVisAnimInfo[boneAnimCount];

            // ボーンアニメーション情報の初期化
            for (int i = 0; i < boneAnimCount; i++)
            { boneAnimInfos[i] = new BoneVisAnimInfo(bone_anims[i]); }
            for (int i = 0; i < boneAnimCount; i++)
            { boneAnimInfos[i].Setup(boneAnimInfos); }

            // 削除可能なボーンの洗い出し
            // ルートノード(boneInfos[0])は削除しないので開始インデックスが 1 となる
            for (int i = 1; i < boneAnimCount; i++)
            {
                bone_vis_bone_animType boneAnim = bone_anims[i];
                BoneVisAnimInfo boneAnimInfo = boneAnimInfos[i];
                if (boneAnim.compress_enable)
                {
                    boneAnimInfo.RemoveFlag = true;
                }
            }

            // <bone_anim> の rigid_body, matrix_index 属性を再設定する
            BoneVisAnimInfo rootBoneAnim = boneAnimInfos[0];
            foreach (BoneVisAnimInfo boneAnimInfo in boneAnimInfos)
            {
                bone_vis_bone_animType boneAnim = boneAnimInfo.BoneAnim;
                // スキニングで利用されるボーンが存在しているという事はリジッドスキンか
                // スムーススキンのメッシュが存在している。その場合はルートボーンに
                // メッシュが移動するので、ルートボーンの rigid_body 属性を true に設定する。
                if (boneAnim.matrix_index[0] != -1 || boneAnim.matrix_index[1] != -1)
                {
                    rootBoneAnim.BoneAnim.rigid_body = true;
                    boneAnim.matrix_index[0] = boneAnim.matrix_index[1] = -1;
                }
                // リジッドボディが参照するボーンが削除される場合、そのボーンより上位階層で
                // 削除されないボーンにメッシュが移動するので、そのボーンの rigid_body 属性
                // を true に設定する。
                if (boneAnimInfo.RemoveFlag && boneAnim.rigid_body)
                {
                    BoneVisAnimInfo uniteTo = boneAnimInfo.GetIncompressibleAncestorBone();
                    uniteTo.BoneAnim.rigid_body = true;
                }
            }
            rootBoneAnim.BoneAnim.matrix_index[0] =
            rootBoneAnim.BoneAnim.matrix_index[1] = -1;

            // アニメーションが付いているボーンが削除されるか確認する
            BoneVisibilityAnimCompressUtility.CheckAnimationRemoved(boneAnimInfos);
            // 新しいボーンのインデックスを設定する
            BoneVisibilityAnimCompressUtility.SetNewIndex(rootBoneAnim);
            // アニメーションの削除
            BoneVisibilityAnimCompressUtility.RemoveBoneAnims(this.Target, boneAnimInfos);
            // 不要になったストリームを削除する
            BoneVisibilityAnimCompressUtility.RemoveUselessStream(this.Target, this.Streams);
        }
    }
}
