﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    internal class modelChecker
    {
        internal static void Check(IfCheckContext context,
            modelType model, List<G3dStream> streams)
        {
            CheckNTBLength(context, model, streams);

            /// TODO: サブメッシュの範囲が重複せず、空きも無いかを確認
            /// かつ0 から順に隙間無く利用されている必要がある
        }

        // 法線、接線、従法線の長さチェック
        private static void CheckNTBLength(IfCheckContext context,
            modelType model, List<G3dStream> streams)
        {
            if (model.vertex_array == null ||
                model.vertex_array.vertex == null) { return; }

            const float Tolerance = 0.0001f;

            List<vtx_attribType> vtx_attribs = new List<vtx_attribType>();
            foreach (vertexType vertex in model.vertex_array.vertex)
            {
                foreach (vtx_attribType vtx_attrib in vertex.vtx_attrib_array.vtx_attrib)
                {
                    if (vtx_attrib.name.StartsWith("_n") ||
                        vtx_attrib.name.StartsWith("_t") ||
                        vtx_attrib.name.StartsWith("_b"))
                    {
                        vtx_attribs.Add(vtx_attrib);
                    }
                }
            }

            G3dParallel.ForEach(vtx_attribs, delegate(vtx_attribType vtx_attrib)
            {
                int stream_index = vtx_attrib.stream_index;
                G3dStream stream = streams[stream_index];
                int stride = (vtx_attrib.type == vtx_attrib_typeType.float4) ? 4 : 3;
                for (int i = 0; i < stream.FloatData.Count; i += stride)
                {
                    float x = stream.FloatData[i];
                    float y = stream.FloatData[i + 1];
                    float z = stream.FloatData[i + 2];
                    float length = (float)Math.Sqrt(x * x + y * y + z * z);
                    float diff = Math.Abs(length - 1f);
                    if (diff > Tolerance)
                    {
                        context.AddError(string.Format(
                            "<vtx_attrib stream_index=\"{0}\">[{1}]: {2}",
                            stream_index, i / stride, IfStrings.Get("modelChecker_CheckNTBLength")));
                    }
                }
            });
        }
    }
}
