﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace nw.g3d.iflib
{
    public class IfCheckContext
    {
        public IfCheckContext()
        {
        }

        public IfCheckContext(string filePath)
        {
            this.FilePath = filePath;
        }

        public void AddError(string error)
        {
            lock (this.Errors)
            {
                this.Errors.Add(error);
            }
        }

        public override string ToString()
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(IfStrings.Get("IfCheckContext_Error",
                this.Errors.Count, this.FilePath));
            foreach (string error in this.Errors)
            {
                builder.AppendLine("  " + error);
            }
            return builder.ToString();
        }

        public void Throw()
        {
            if (this.Result) { return; }
            throw new Exception(this.ToString());
        }

        public bool Result { get { return (this.Errors.Count == 0); } }

        public string FilePath { get; private set; } = string.Empty;
        public readonly List<string> Errors = new List<string>();
    }
}
