﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Reflection;
using System.Runtime;
using nw.g3d.iflib;
using nw.g3d.nw4f_3dif;
using nw.g3d.toollib;
using System.Resources;

namespace nw.g3d.b2a
{
    // 中間ファイルテキストコンバータ
    public class g3db2a : SimpleFilterTool<SimpleFilterToolParamsNotRequireXsdCheck>
    {
        // エントリポイント
        public static void Main()
        {
            string path = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            ProfileOptimization.SetProfileRoot(path);
            ProfileOptimization.StartProfile(Path.GetFileNameWithoutExtension(
                Assembly.GetExecutingAssembly().Location) + ".JIT.Profile");

            var helpResourceManager = new ResourceManager("nw.g3d.b2a.Resources.CommandLineHelp", typeof(g3db2a).Assembly);
            SimpleFilterToolParams.CustomDescriptionConverterFunc = (x, y) =>
            {
                return helpResourceManager.GetString(x);
            };

            g3db2a g3db2a = new g3db2a();
            G3dToolUtility.Run(delegate { g3db2a.Run(); });
        }

        // コンストラクタ
        public g3db2a() : base("nw.g3d.b2a.Resources.StringResource") { }

        // ファイルパスのチェック
        protected override bool CheckFilePath(string filePath)
        {
            if (!G3dPath.IsBinaryPath(filePath)) { return false; }
            return base.CheckFilePath(filePath);
        }

        // ファイル処理
        protected override void ProcessFile(int index, string filePath)
        {
            nw4f_3difType nw4f_3dif = IfBinaryReadUtility.Read(filePath, this.XsdBasePath);
            string textPath = G3dPath.ToTextPath(filePath);
            IfTextWriteUtility.Write(nw4f_3dif, textPath, this.XsdBasePath);
        }
    }
}
