﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "FileOptionParser.h"

namespace nn {
namespace g3dTool {

FileOptionParser::FileOptionParser()
{
    SetOption( m_OptionDefinitions.externalFileAlign.Define(
        false, "external-file-alignment", "Specify the alignment for the external_file as it is [LOCAL]." ) );
    SetArgs( &m_InputArgArray );
}

void FileOptionParser::ResetOptions( void )
{
    m_InputArgArray.clear();

    // コマンドラインオプションを初期値に戻します。
    m_OptionDefinitions.externalFileAlign.SetExisting( false );
    m_OptionDefinitions.externalFileAlign.SetValue( "0" );
}

void FileOptionParser::Parse( const std::vector< std::string >& srcStrArray )
{
    const char** strPtrArray = new( const char* [ srcStrArray.size() ] );
    for( int idx = 0; idx < static_cast< int >( srcStrArray.size() ); ++idx )
    {
        strPtrArray[ idx ] = reinterpret_cast< const char* const >( srcStrArray[ idx ].c_str() );
    }
    nn::gfxTool::CommandLineParser::Parse( static_cast< int >( srcStrArray.size() ), strPtrArray );
    delete[] strPtrArray;
}

}
}
