﻿namespace G3dCore.Windows.Actions
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Interactivity;
    using G3dCore.Messaging;

    /// <summary>
    /// 確認ダイアログを表示するアクション
    /// </summary>
    public class ConfirmDialogAction : TriggerAction<DependencyObject>
    {
        /// <summary>
        /// アクションを呼び出します。
        /// </summary>
        /// <param name="parameter">アクションへのパラメーター。</param>
        protected override void Invoke(object parameter)
        {
            var args = parameter as MessageEventArgs;
            if (args == null)
            {
                return;
            }

            var input = (InputArg)args.Message.Body;
            var output = new OutputArg();

            MessageBoxResult result = MessageBox.Show(
                string.Format(Properties.Resources.ConfirmSave, input.FileName),
                "Chalkboard",
                MessageBoxButton.YesNoCancel,
                MessageBoxImage.Information,
                MessageBoxResult.Cancel,
                MessageBoxOptions.DefaultDesktopOnly);

            if (result == MessageBoxResult.Yes)
            {
                output.Result = true;
            }
            else if (result == MessageBoxResult.No)
            {
                output.Result = false;
            }
            else
            {
                output.Result = null;
            }

            args.Message.Response = output;
            args.Callback(args.Message);
        }

        public class InputArg
        {
            public string FileName { get; set; }
        }

        public class OutputArg
        {
            public bool? Result { get; internal set; }
        }
    }
}
