﻿namespace G3dCore.InteropServices
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// kernel32 のインポート関数のクラスです。
    /// </summary>
    public static class Kernel32
    {
        /// <summary>
        /// 指定された実行可能モジュールを、呼び出し側プロセスのアドレス空間内にマップします。
        /// </summary>
        /// <param name="fileName">モジュールのファイル名です。</param>
        /// <returns>関数が成功すると、モジュールのハンドルが返ります。</returns>
        [DllImport("kernel32", CharSet = CharSet.Unicode, SetLastError = true)]
        public static extern IntPtr LoadLibrary(string fileName);

        /// <summary>
        /// ロード済みのダイナミックリンクライブラリ（DLL）モジュールの参照カウントを 1 つ減らします。
        /// </summary>
        /// <param name="handleModule">DLL モジュールのハンドルです。</param>
        /// <returns>関数が成功すると、0 以外の値が返ります。</returns>
        [DllImport("kernel32", SetLastError = true)]
        public static extern bool FreeLibrary(IntPtr handleModule);

        /// <summary>
        /// ダイナミックリンクライブラリ（DLL）が持つ、指定されたエクスポート済み関数のアドレスを取得します。
        /// </summary>
        /// <param name="handleModule">DLL モジュールのハンドルです。</param>
        /// <param name="procName">関数名です。</param>
        /// <returns>関数が成功すると、DLL のエクスポート済み関数のアドレスが返ります。</returns>
        [DllImport("kernel32", CharSet = CharSet.Ansi, SetLastError = true, ExactSpelling = false)]
        public static extern IntPtr GetProcAddress(IntPtr handleModule, string procName);
    }
}
