﻿namespace G3dCore.Configurations
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Configurations;

    /// <summary>
    /// ユーザコンフィグクラスです。
    /// </summary>
    public sealed class UserConfig : ExtensibleConfig
    {
        private string configFilePath = string.Empty;

        /// <summary>
        /// コンフィグファイルをロードします。
        /// </summary>
        /// <param name="path">コンフィグファイルのパスです。</param>
        /// <returns>ロードしたコンフィグを返します。</returns>
        public static UserConfig Load(string path)
        {
            var config = Config.Load<UserConfig>(path);
            if (config == null)
            {
                config = new UserConfig();
            }

            config.configFilePath = path;

            return config;
        }

        /// <summary>
        /// コンフィグファイルを保存します。
        /// </summary>
        public override void Save()
        {
            throw new NotSupportedException();
        }

        /// <summary>
        /// コンフィグファイルのパスを取得します。
        /// </summary>
        /// <returns>コンフィグファイルのパスを返します。</returns>
        public string GetConfigFilePath()
        {
            return this.configFilePath;
        }
    }
}
