﻿namespace G3dCore.Configurations.TeamConfigs
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// アプリケーションモードです。
    /// </summary>
    public enum AppMode
    {
        /// <summary>
        /// 標準モード
        /// </summary>
        Default,

        /// <summary>
        /// 互換モード
        /// </summary>
        AglCompatible
    }

    /// <summary>
    /// ShaderAssistAddons のチームコンフィグのサブコンフィグです。
    /// </summary>
    [Serializable]
    public class ShaderAssistConfig : SubConfig
    {
        private AppMode appMode = AppMode.AglCompatible;

        /// <summary>
        /// アプリケーションモードを取得設定します。
        /// </summary>
        public AppMode AppMode
        {
            get
            {
                return this.appMode;
            }

            set
            {
                this.SetProperty(ref this.appMode, value);
            }
        }
    }
}
