﻿namespace ChalkboardCore.Plugins.Applications
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows.Controls;
    using Opal.App;
    using Opal.Modules.Output;
    using Opal.Plugins;
    using Opal.Properties;
    using Opal.Resources;
    using Opal.Storages;
    using Opal.ViewModels;
    using Opal.Windows.Tools;

    /// <summary>
    /// ログ出力作成クラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public sealed class OutputToolMakerPlugin : ToolMakerPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public OutputToolMakerPlugin()
            : base("Output", Labels.Output)
        {
        }

        /// <summary>
        /// ビューを生成します。
        /// </summary>
        /// <returns>ビューのインスタンスを返します。</returns>
        public override Control CreateView()
        {
            return new OutputView();
        }

        /// <summary>
        /// ビューに対応するビューモデルを生成します。
        /// </summary>
        /// <returns>ビューモデルのインスタンスを返します。</returns>
        public override ToolViewModel CreateViewModel()
        {
            var logManager = AppManager.GetLogManager();
            var conductor = logManager.GetConductor<OutputConductor>();
            Debug.Assert(conductor != null);
            var viewModel = new OutputViewModel();
            conductor.SetOutputViewModel(viewModel);
            viewModel.Title = "ログ出力";
            return viewModel;
        }
    }
}
