﻿namespace ShaderAssistAddons.Tools
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.Composition;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Windows;
    using System.Windows.Controls;
    using G3dCore.Resources;
    using G3dCore.ViewModels;
    using Opal.App;
    using Opal.Plugins;
    using Opal.Storages;
    using Opal.ViewModels;
    using Opal.Windows.Tools;
    using ShaderAssistAddons.Modules.FileList.ViewModels;
    using ShaderAssistAddons.Modules.FileList.Views;
    using ShaderAssistAddons.Properties;

    /// <summary>
    /// ファイルリストツール作成クラスです。
    /// </summary>
    [Export(typeof(IPlugin))]
    public class FileListToolMaker : ToolMakerPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public FileListToolMaker()
            : base("G3dFileList", Labels.FileList)
        {
        }

        /// <summary>
        /// ビューを生成します。
        /// </summary>
        /// <returns>ビューのインスタンスを返します。</returns>
        public override Control CreateView()
        {
            return new FileListView();
        }

        /// <summary>
        /// ビューに対応するビューモデルを生成します。
        /// </summary>
        /// <returns>ビューモデルのインスタンスを返します。</returns>
        public override ToolViewModel CreateViewModel()
        {
            var viewModel = new FileListViewModel();
            viewModel.Title = Labels.FileList;
            return viewModel;
        }
    }
}
