﻿namespace ShaderAssistAddons.Modules.ShaderConfig.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ViewModels;

    /// <summary>
    /// ウィザードページのビューモデルの抽象クラスです。
    /// </summary>
    public abstract class WizardPageViewModel : ViewModel
    {
        private WizardViewModel wizardViewModel = null;
        private string description;
        private bool canCancel = true;

        /// <summary>
        /// ウィザードビューモデルを取得します。
        /// </summary>
        public WizardViewModel WizardViewModel
        {
            get
            {
                return this.wizardViewModel;
            }
        }

        /// <summary>
        /// 説明を取得します。
        /// </summary>
        public string Description
        {
            get
            {
                return this.description;
            }

            protected set
            {
                this.SetProperty(ref this.description, value);
            }
        }

        /// <summary>
        /// キャンセル可能かを取得します。
        /// </summary>
        public bool CanCancel
        {
            get
            {
                return this.canCancel;
            }

            protected set
            {
                this.SetProperty(ref this.canCancel, value);
            }
        }

        /// <summary>
        /// 次ページに進めるかを取得します。
        /// </summary>
        /// <returns>進める場合 true を返します。</returns>
        public abstract bool CanGoNext();

        /// <summary>
        /// 前ページに進めるかを取得します。
        /// </summary>
        /// <returns>進める場合 true を返します。</returns>
        public abstract bool CanGoBack();

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="wizardViewModel">ウィザードビューモデルです。</param>
        public WizardPageViewModel(WizardViewModel wizardViewModel)
        {
            if (wizardViewModel == null) throw new ArgumentNullException();
            this.wizardViewModel = wizardViewModel;
        }
    }
}
