﻿namespace Chalkboard
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.App;
    using Opal.Configurations;
    using Opal.Logs;
    using Opal.Menus;
    using Opal.Operations;
    using Opal.Panes;
    using Opal.Storages;
    using Opal.Utilities;
    using Opal.Windows;
    using Opal.Windows.Documents;
    using Opal.Windows.Tools;

    /// <summary>
    /// アプリケーション管理クラスです。
    /// </summary>
    internal class ChalkboardManager : AppManager
    {
        /// <summary>
        /// ドキュメントマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddDocumentManager(DocumentManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Document, manager);
        }

        /// <summary>
        /// ツールマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddToolManager(ToolManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Tool, manager);
        }

        /// <summary>
        /// ウィンドウマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddWindowManager(WindowManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Window, manager);
        }

        /// <summary>
        /// ストレージマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddStorageManager(StorageManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Storage, manager);
        }

        /// <summary>
        /// ロガーマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddLoggerManager(LogManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Log, manager);
        }

        /// <summary>
        /// オペレーションマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddOperationManager(OperationManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Operation, manager);
        }

        /// <summary>
        /// ペインマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddPaneManager(PaneManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Pane, manager);
        }

        /// <summary>
        /// メニューマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddMenuManager(MenuManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Menu, manager);
        }

        /// <summary>
        /// コンフィグマネージャーを追加します。
        /// </summary>
        /// <param name="manager">追加するマネージャーです。</param>
        internal void AddConfigManager(ConfigManager manager)
        {
            Debug.Assert(manager != null);
            this.AddManagerInternal(ManagerKey.Config, manager);
        }
    }
}
