﻿# IronPython 2.7.5 の HTMLParser だとパースに失敗するファイルがあった。
# python 3.4.3 だと問題なかった。
from html.parser import HTMLParser
import re
import glob
import codecs
import sys
import os

# 3DEditor のページを示すアンカー
capturePage = re.compile('Anchor_[0-9]+_3ded_(.+)');

# ページ内のアンカー
captureAnchor = re.compile('Anchor_[0-9]+_(.+)');

# 処理対象のパス
path = '*.html'
if len(sys.argv) >= 2:
    path = sys.argv[1] + r'\*.html'

class MyHTMLParser(HTMLParser):
    def handle_starttag(self, tag, attrs):
        global pageId
        global anchors
        global capturePage
        for attr in attrs:
            if attr[0] == 'name':
                if pageId == None and capturePage.match(attr[1]) != None:
                    pageId = capturePage.match(attr[1]).group(1)
                else:
                    anchors.append(attr[1])

urls = []
ids = []
parser = MyHTMLParser()
for doc in glob.glob(path):
    pageId = None
    anchors = []
    f = codecs.open(doc, 'r', 'utf-8')
    parser.feed(f.read())
    if pageId != None:
        fileName = os.path.basename(doc)
        urls.append(fileName)
        ids.append('p_' + pageId);
        for anchor in anchors:
            m = captureAnchor.match(anchor)
            if m != None:
                urls.append(fileName + '#' + anchor)
                ids.append('p_' + pageId + '_a_' + m.group(1))

print('//urls')
for url in urls:
    print('            "' + url + '",')
print()

print('//ids')
for id in ids:
    print(id + ',')
