﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml.Serialization;

namespace AppConfig
{
    public class Setting
    {
        public MainFrame				MainFrame				{ get; set; }
        public ObjectView				ObjectView				{ get; set; }
        public PropertyEdit				PropertyEdit			{ get; set; }
        public IO						IO						{ get; set; }
        public CurveEditor				CurveEditor				{ get; set; }
        public ColorPicker				ColorPicker				{ get; set; }
        public ColorPicker              MarkColorPicker         { get; set; }
        public SaveDirectory			SaveDirectory			{ get; set; }
        public BinarySave				BinarySave				{ get; set; }
        public Preview					Preview					{ get; set; }
        public TextureDetailsDialog		TextureDetailsDialog	{ get; set; }
        public MaterialTemplateSetting	MaterialTemplateDialog	{ get; set; }
        public AppConfig.UserCommandLog UserCommandLog { get; set; }
        //
        public DebugSetting				Debug					{ get; set; } // null もあり得る

        [XmlAttribute]
        public string Version { get; set; }
        public Setting()
        {
            this.Initialize();
        }

        public Setting(bool initialize)
        {
            this.Version = ConfigCommon.Common.Version;
            if (initialize)
            {
                this.Initialize();
            }
        }

        private void Initialize()
        {
            this.Version = ConfigCommon.Common.Version;
            this.MainFrame = new MainFrame();
            this.ObjectView = new ObjectView();
            this.PropertyEdit = new PropertyEdit();
            this.IO = new IO();
            this.CurveEditor = new CurveEditor();
            this.ColorPicker = new ColorPicker();
            this.MarkColorPicker = new ColorPicker();
            this.SaveDirectory = new SaveDirectory();
            this.BinarySave = new BinarySave();
            this.Preview = new Preview();
            this.TextureDetailsDialog = new TextureDetailsDialog();
            this.MaterialTemplateDialog = new MaterialTemplateSetting();
            this.UserCommandLog = new AppConfig.UserCommandLog();
#if DEBUG
            this.Debug = new DebugSetting();
#endif
        }

    }
}
