﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using App.Controls;

namespace Viewer
{
    public sealed partial class OnAttachCommandReceivedDialog_NonModified : OkDialog
    {
        public enum Mode
        {
            ExistringModel,	// 既存モデルをアタッチ
            Cancel			// アタッチをキャンセル
        }

        public Mode AttachMode{ get; private set; }

        public OnAttachCommandReceivedDialog_NonModified(string modelName)
        {
            InitializeComponent();

            AttachMode = Mode.Cancel;

            lblMessage.Text = string.Format(lblMessage.Text, modelName);

            rbnExistringModel.Tag	= Mode.ExistringModel;
            rbnCancel.Tag			= Mode.Cancel;

            rbnExistringModel.SetCheckedByTag(AttachMode);
            rbnCancel.SetCheckedByTag(AttachMode);
        }

        private void Mode_RadioChecked(object sender, EventArgs e)
        {
            AttachMode = (Mode)(sender as Control).Tag;
        }

        private void OnAttachCommandReceivedDialog_NonModified_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (DialogResult != DialogResult.OK)
            {
                AttachMode = Mode.Cancel;
            }
        }
    }
}
